/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme;

import bibliothek.extension.gui.dock.theme.eclipse.DefaultEclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseButtonTitle;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseColorScheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseDockTitleFactory;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseDockableSelection;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseStationPaint;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.RoundRectButton;
import bibliothek.extension.gui.dock.theme.eclipse.RoundRectDropDownButton;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.EclipseDisplayerFactory;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.ArchGradientPainter;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BasicTabDockTitle;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPainter;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.accept.DockAcceptance;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.ButtonDockAction;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.MenuDockAction;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewGenerator;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.dockable.MovingImage;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentFactory;
import bibliothek.gui.dock.station.stack.StackDockComponentParent;
import bibliothek.gui.dock.station.stack.tab.MenuLineLayout;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.BasicTheme;
import bibliothek.gui.dock.themes.ColorScheme;
import bibliothek.gui.dock.themes.ThemeProperties;
import bibliothek.gui.dock.themes.basic.BasicDockTitle;
import bibliothek.gui.dock.themes.basic.BasicDockTitleFactory;
import bibliothek.gui.dock.themes.basic.NoSpanFactory;
import bibliothek.gui.dock.themes.basic.action.BasicButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicMenuHandler;
import bibliothek.gui.dock.themes.basic.action.BasicSelectableHandler;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.nostack.NoStackAcceptance;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleManager;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.icon.DefaultIconScheme;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;
import javax.swing.JComponent;

@ThemeProperties(authors={"Janni Kovacs", "Benjamin Sigg"}, descriptionBundle="theme.eclipse.description", nameBundle="theme.eclipse", webpages={""})
public class EclipseTheme
extends BasicTheme {
    public static final PropertyKey<Boolean> PAINT_ICONS_WHEN_DESELECTED = new PropertyKey<Boolean>("EclipseTheme paint icons when deselected", new ConstantPropertyFactory<Boolean>(false), true);
    public static final PropertyKey<TabPainter> TAB_PAINTER = new PropertyKey<TabPainter>("EclipseTheme tab painter", new ConstantPropertyFactory<TabPainter>(ArchGradientPainter.FACTORY), true);
    public static final PropertyKey<EclipseThemeConnector> THEME_CONNECTOR = new PropertyKey<DefaultEclipseThemeConnector>("EclipseTheme theme connector", new ConstantPropertyFactory<DefaultEclipseThemeConnector>(new DefaultEclipseThemeConnector()), true);
    public static final PropertyKey<ColorScheme> ECLIPSE_COLOR_SCHEME = new PropertyKey<ColorScheme>("dock.ui.EclipseTheme.ColorScheme", new DynamicPropertyFactory<ColorScheme>(){

        @Override
        public ColorScheme getDefault(PropertyKey<ColorScheme> key, DockProperties properties) {
            return new EclipseColorScheme();
        }
    }, true);
    @Deprecated
    public static final String TAB_DOCK_TITLE = "eclipse.tab";
    private DockAcceptance acceptance = new NoStackAcceptance();

    public EclipseTheme() {
        this.setColorSchemeKey(ECLIPSE_COLOR_SCHEME);
        this.setStackDockComponentFactory(new StackDockComponentFactory(){

            @Override
            public StackDockComponent create(StackDockComponentParent station) {
                return new EclipseTabPane(EclipseTheme.this, station.getStackDockParent());
            }
        }, Priority.DEFAULT);
        this.setDisplayerFactory(new EclipseDisplayerFactory(this), Priority.DEFAULT);
        this.setPaint(new EclipseStationPaint(), Priority.DEFAULT);
        this.setMovingImageFactory(new DockableMovingImageFactory(){

            @Override
            public MovingImage create(DockController controller, Dockable dockable) {
                return null;
            }

            @Override
            public MovingImage create(DockController controller, DockTitle snatched) {
                return null;
            }
        }, Priority.DEFAULT);
        this.setTitleFactory(new BasicDockTitleFactory(){

            @Override
            public void request(DockTitleRequest request) {
                request.answer(new BasicDockTitle(request.getTarget(), request.getVersion()));
            }
        }, Priority.DEFAULT);
        this.setDockableSelection(new EclipseDockableSelection(), Priority.DEFAULT);
        this.setTabPlacement(TabPlacement.TOP_OF_DOCKABLE, Priority.DEFAULT);
        this.setSpanFactory(new NoSpanFactory());
    }

    @Override
    public void install(DockController controller) {
        DockTitleManager titleManager = controller.getDockTitleManager();
        titleManager.registerTheme(TAB_DOCK_TITLE, BasicTabDockTitle.FACTORY);
        super.install(controller);
        controller.getIcons().setScheme(Priority.THEME, new DefaultIconScheme("data/bibliothek/gui/dock/core/eclipse/icons.ini", EclipseTheme.class.getClassLoader(), controller));
        EclipseDockTitleFactory factory = new EclipseDockTitleFactory(this, new ControllerTitleFactory());
        titleManager.registerTheme("split", factory);
        titleManager.registerTheme("flap window", factory);
        titleManager.registerTheme("screen dock", factory);
        titleManager.registerTheme("stack", factory);
        controller.addAcceptance(this.acceptance);
        controller.getProperties().set(TabPane.LAYOUT_MANAGER, new MenuLineLayout(), Priority.THEME);
        titleManager.registerTheme("flap button", new DockTitleFactory(){

            @Override
            public void install(DockTitleRequest request) {
            }

            @Override
            public void uninstall(DockTitleRequest request) {
            }

            @Override
            public void request(DockTitleRequest request) {
                request.answer(new EclipseButtonTitle(request.getTarget(), request.getVersion()));
            }
        });
        controller.getActionViewConverter().putTheme(ActionType.BUTTON, ViewTarget.TITLE, new ViewGenerator<ButtonDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, ButtonDockAction action, Dockable dockable) {
                BasicButtonHandler handler = new BasicButtonHandler(action, dockable);
                RoundRectButton button = new RoundRectButton(handler, handler);
                handler.setModel(button.getModel());
                return handler;
            }
        });
        controller.getActionViewConverter().putTheme(ActionType.CHECK, ViewTarget.TITLE, new ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, SelectableDockAction action, Dockable dockable) {
                BasicSelectableHandler.Check handler = new BasicSelectableHandler.Check(action, dockable);
                RoundRectButton button = new RoundRectButton(handler, handler);
                handler.setModel(button.getModel());
                return handler;
            }
        });
        controller.getActionViewConverter().putTheme(ActionType.MENU, ViewTarget.TITLE, new ViewGenerator<MenuDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, MenuDockAction action, Dockable dockable) {
                BasicMenuHandler handler = new BasicMenuHandler(action, dockable);
                RoundRectButton button = new RoundRectButton(handler, handler);
                handler.setModel(button.getModel());
                return handler;
            }
        });
        controller.getActionViewConverter().putTheme(ActionType.RADIO, ViewTarget.TITLE, new ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, SelectableDockAction action, Dockable dockable) {
                BasicSelectableHandler.Radio handler = new BasicSelectableHandler.Radio(action, dockable);
                RoundRectButton button = new RoundRectButton(handler, handler);
                handler.setModel(button.getModel());
                return handler;
            }
        });
        controller.getActionViewConverter().putTheme(ActionType.DROP_DOWN, ViewTarget.TITLE, new ViewGenerator<DropDownAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, DropDownAction action, Dockable dockable) {
                BasicDropDownButtonHandler handler = new BasicDropDownButtonHandler(action, dockable);
                RoundRectDropDownButton button = new RoundRectDropDownButton(handler);
                handler.setModel(button.getModel());
                return handler;
            }
        });
    }

    @Override
    public void uninstall(DockController controller) {
        super.uninstall(controller);
        controller.getIcons().setScheme(Priority.THEME, null);
        controller.getDockTitleManager().clearThemeFactories();
        controller.removeAcceptance(this.acceptance);
        controller.getProperties().unset(TabPane.LAYOUT_MANAGER, Priority.THEME);
        controller.getActionViewConverter().putTheme(ActionType.BUTTON, ViewTarget.TITLE, null);
        controller.getActionViewConverter().putTheme(ActionType.CHECK, ViewTarget.TITLE, null);
        controller.getActionViewConverter().putTheme(ActionType.MENU, ViewTarget.TITLE, null);
        controller.getActionViewConverter().putTheme(ActionType.RADIO, ViewTarget.TITLE, null);
        controller.getActionViewConverter().putTheme(ActionType.DROP_DOWN, ViewTarget.TITLE, null);
    }

    public EclipseThemeConnector getThemeConnector(DockController controller) {
        EclipseThemeConnector connector = null;
        if (controller != null) {
            connector = controller.getProperties().get(THEME_CONNECTOR);
        }
        if (connector == null) {
            connector = THEME_CONNECTOR.getDefault(null);
        }
        return connector;
    }
}

