/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme;

import bibliothek.gui.dock.themes.ColorScheme;
import bibliothek.gui.dock.themes.color.AbstractColorScheme;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.UIScheme;
import bibliothek.gui.dock.util.UISchemeEvent;
import bibliothek.gui.dock.util.UISchemeListener;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.DockColor;
import bibliothek.util.Path;
import java.awt.Color;
import java.util.Collection;
import java.util.Set;

public class IdentifiedColorScheme
extends AbstractColorScheme {
    private String id;
    private ColorScheme delegate;
    private UISchemeListener<Color, DockColor, ColorBridge> delegateListener = new UISchemeListener<Color, DockColor, ColorBridge>(){

        @Override
        public void changed(final UISchemeEvent<Color, DockColor, ColorBridge> event) {
            IdentifiedColorScheme.this.fire(new UISchemeEvent<Color, DockColor, ColorBridge>(){

                @Override
                public Collection<Path> changedBridges(Set<Path> names) {
                    return event.changedBridges(names);
                }

                @Override
                public Collection<String> changedResources(Set<String> names) {
                    return event.changedResources(names);
                }

                @Override
                public UIScheme<Color, DockColor, ColorBridge> getScheme() {
                    return IdentifiedColorScheme.this;
                }
            });
        }
    };

    public IdentifiedColorScheme(String id, ColorScheme delegate) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        this.id = id;
        this.delegate = delegate;
    }

    @Override
    public void addListener(UISchemeListener<Color, DockColor, ColorBridge> listener) {
        boolean has = this.hasListeners();
        super.addListener(listener);
        if (!has) {
            this.delegate.addListener(this.delegateListener);
        }
    }

    @Override
    public void removeListener(UISchemeListener<Color, DockColor, ColorBridge> listener) {
        super.removeListener(listener);
        if (!this.hasListeners()) {
            this.delegate.removeListener(this.delegateListener);
        }
    }

    @Override
    public void install(UIProperties<Color, DockColor, ColorBridge> properties) {
        super.install(properties);
        this.delegate.uninstall(properties);
    }

    @Override
    public void uninstall(UIProperties<Color, DockColor, ColorBridge> properties) {
        super.uninstall(properties);
        this.delegate.uninstall(properties);
    }

    @Override
    protected void updateUI() {
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentifiedColorScheme other = (IdentifiedColorScheme)obj;
        return this.id.equals(other.id);
    }

    @Override
    public ColorBridge getBridge(Path name, UIProperties<Color, DockColor, ColorBridge> properties) {
        return this.delegate.getBridge(name, properties);
    }

    @Override
    public Color getResource(String name, UIProperties<Color, DockColor, ColorBridge> properties) {
        return this.delegate.getResource(name, properties);
    }
}

