/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.focus.FocusController;
import bibliothek.gui.dock.control.focus.FocusStrategy;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.event.FocusVetoListener;
import bibliothek.gui.dock.title.DockTitle;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFocusController
implements FocusController {
    private DockController controller;
    private FocusStrategy strategy;
    private List<DockableFocusListener> dockableFocusListeners = new ArrayList<DockableFocusListener>();
    private List<FocusVetoListener> vetos = new ArrayList<FocusVetoListener>();
    private int frozen = 0;

    public AbstractFocusController(DockController controller) {
        this.controller = controller;
    }

    @Override
    public void setStrategy(FocusStrategy strategy) {
        if (this.strategy != strategy) {
            if (this.strategy != null) {
                this.strategy.unbind();
            }
            this.strategy = strategy;
            if (strategy != null) {
                strategy.bind();
            }
        }
    }

    @Override
    public FocusStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public void freezeFocus() {
        ++this.frozen;
    }

    @Override
    public void meltFocus() {
        --this.frozen;
    }

    protected boolean isFrozen() {
        return this.frozen > 0;
    }

    @Override
    public void addVetoListener(FocusVetoListener listener) {
        this.vetos.add(listener);
    }

    @Override
    public void removeVetoListener(FocusVetoListener listener) {
        this.vetos.remove(listener);
    }

    protected FocusVetoListener.FocusVeto fireVetoTitle(DockTitle title) {
        for (FocusVetoListener listener : this.vetos.toArray(new FocusVetoListener[this.vetos.size()])) {
            FocusVetoListener.FocusVeto veto = listener.vetoFocus((FocusController)this, title);
            if (veto == FocusVetoListener.FocusVeto.NONE) continue;
            return veto;
        }
        return FocusVetoListener.FocusVeto.NONE;
    }

    protected FocusVetoListener.FocusVeto fireVetoDockable(Dockable dockable) {
        for (FocusVetoListener listener : this.vetos.toArray(new FocusVetoListener[this.vetos.size()])) {
            FocusVetoListener.FocusVeto veto = listener.vetoFocus((FocusController)this, dockable);
            if (veto == FocusVetoListener.FocusVeto.NONE) continue;
            return veto;
        }
        return FocusVetoListener.FocusVeto.NONE;
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    @Override
    public void addDockableFocusListener(DockableFocusListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.dockableFocusListeners.add(listener);
    }

    @Override
    public void removeDockableFocusListener(DockableFocusListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.dockableFocusListeners.remove(listener);
    }

    protected DockableFocusListener[] dockableFocusListeners() {
        return this.dockableFocusListeners.toArray(new DockableFocusListener[this.dockableFocusListeners.size()]);
    }

    protected void fireDockableFocused(Dockable oldFocused, Dockable newFocused) {
        DockableFocusEvent event = new DockableFocusEvent(this.controller, oldFocused, newFocused);
        for (DockableFocusListener listener : this.dockableFocusListeners()) {
            listener.dockableFocused(event);
        }
    }
}

