/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.actions.GroupedSelectableDockAction;
import bibliothek.gui.dock.event.FlapDockListener;
import bibliothek.gui.dock.station.flap.button.ButtonContentAction;
import javax.swing.Icon;

@ButtonContentAction
public class FlapDockHoldToggle
extends GroupedSelectableDockAction.Check<Boolean>
implements ListeningDockAction {
    private FlapDockStation flap;
    private DockController controller;
    private Listener[] icons;
    private DockActionText textStick;
    private DockActionText textStickTooltip;
    private DockActionText textFree;
    private DockActionText textFreeTooltip;

    public FlapDockHoldToggle(FlapDockStation station) {
        super(null);
        this.setRemoveEmptyGroups(false);
        this.flap = station;
        this.icons = new Listener[]{new Listener("flap.hold"), new Listener("flap.free")};
        station.addFlapDockStationListener(new FlapDockListener(){

            @Override
            public void holdChanged(FlapDockStation station, Dockable dockable, boolean hold) {
                if (FlapDockHoldToggle.this.isBound(dockable)) {
                    FlapDockHoldToggle.this.setGroup(hold, dockable);
                }
            }
        });
        this.setSelected(Boolean.FALSE, false);
        this.setSelected(Boolean.TRUE, true);
        this.textStick = new DockActionText("flap.stick.true", this){

            @Override
            protected void changed(String oldValue, String newValue) {
                FlapDockHoldToggle.this.setText(Boolean.TRUE, newValue);
            }
        };
        this.textFree = new DockActionText("flap.stick.false", this){

            @Override
            protected void changed(String oldValue, String newValue) {
                FlapDockHoldToggle.this.setText(Boolean.FALSE, newValue);
            }
        };
        this.textStickTooltip = new DockActionText("flap.stick.true.tooltip", this){

            @Override
            protected void changed(String oldValue, String newValue) {
                FlapDockHoldToggle.this.setTooltip(Boolean.TRUE, newValue);
            }
        };
        this.textFreeTooltip = new DockActionText("flap.stick.false.tooltip", this){

            @Override
            protected void changed(String oldValue, String newValue) {
                FlapDockHoldToggle.this.setTooltip(Boolean.FALSE, newValue);
            }
        };
    }

    @Override
    public boolean trigger(Dockable dockable) {
        this.setSelected(dockable, !this.isSelected(dockable));
        return true;
    }

    @Override
    public void setSelected(Dockable dockable, boolean selected) {
        this.flap.setHold(dockable, selected);
        this.setGroup(selected, dockable);
    }

    @Override
    protected Boolean createGroupKey(Dockable dockable) {
        return this.flap.isHold(dockable);
    }

    @Override
    public void setController(DockController controller) {
        if (this.controller != controller) {
            this.controller = controller;
            for (Listener icon : this.icons) {
                icon.setController(controller);
            }
            this.textStick.setController(controller);
            this.textFree.setController(controller);
            this.textStickTooltip.setController(controller);
            this.textFreeTooltip.setController(controller);
        }
    }

    private class Listener
    extends DockActionIcon {
        public Listener(String id) {
            super(id, FlapDockHoldToggle.this);
        }

        @Override
        protected void changed(Icon oldValue, Icon icon) {
            String key = this.getId();
            if (key.equals("flap.free")) {
                FlapDockHoldToggle.this.setIcon(false, icon);
            } else {
                FlapDockHoldToggle.this.setSelectedIcon(true, icon);
            }
        }
    }
}

