/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab.layouting;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.station.stack.tab.layouting.TabsLayoutBlock;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractTabsLayoutBlock
implements TabsLayoutBlock {
    private List<Tab> tabs = new ArrayList<Tab>();
    private Rectangle bounds = new Rectangle();
    private TabPane pane;
    private TabPlacement orientation = TabPlacement.TOP_OF_DOCKABLE;

    public void setPane(TabPane pane) {
        this.pane = pane;
    }

    public TabPane getPane() {
        return this.pane;
    }

    public TabPlacement getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(TabPlacement side) {
        if (side == null) {
            throw new IllegalArgumentException("side must not be null");
        }
        if (this.orientation != side) {
            this.orientation = side;
            for (Tab tab : this.tabs) {
                tab.setOrientation(side);
            }
        }
    }

    public Tab getSelectedTab() {
        if (this.pane == null) {
            return null;
        }
        Dockable dockable = this.pane.getSelectedDockable();
        for (Tab tab : this.tabs) {
            if (tab.getDockable() != dockable) continue;
            return tab;
        }
        return null;
    }

    public void checkExistence() {
        ListIterator<Tab> iterator = this.tabs.listIterator();
        Tab[] existing = this.pane.getTabs();
        while (iterator.hasNext()) {
            Tab next = iterator.next();
            boolean found = false;
            for (Tab tab : existing) {
                if (next != tab) continue;
                found = true;
                break;
            }
            if (found) continue;
            iterator.remove();
        }
    }

    public Tab[] getTabs() {
        return this.tabs.toArray(new Tab[this.tabs.size()]);
    }

    public int getTabsCount() {
        return this.tabs.size();
    }

    public void addTab(Tab tab) {
        this.insertTab(tab, this.tabs.size());
    }

    public void insertTab(Tab tab) {
        int[] locations = this.getOriginalTabLocations();
        TabPane pane = this.getPane();
        Dockable[] dockables = pane.getDockables();
        int index = -1;
        for (int i = 0; i < dockables.length; ++i) {
            if (dockables[i] != tab.getDockable()) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new IllegalArgumentException(tab.getDockable() + " is not a child of the TabPane");
        }
        int wrongSmaller = 0;
        int wrongBigger = 0;
        for (int i = 0; i < locations.length; ++i) {
            if (locations[i] >= index) continue;
            ++wrongSmaller;
        }
        int bestLocation = 0;
        int bestCount = wrongBigger + wrongSmaller;
        for (int i = 0; i < locations.length; ++i) {
            if (locations[i] < index) {
                --wrongSmaller;
            } else if (locations[i] > index) {
                ++wrongBigger;
            }
            int count = wrongSmaller + wrongBigger;
            if (count >= bestCount) continue;
            bestCount = count;
            bestLocation = i + 1;
        }
        this.insertTab(tab, bestLocation);
    }

    public int indexOfTab(Tab tab) {
        return this.tabs.indexOf(tab);
    }

    public Tab[] getTabsOrderedByImportance() {
        int i;
        int i2;
        int selectedIndex;
        if (this.pane == null) {
            throw new IllegalStateException("no TabPane available");
        }
        Dockable[] dockables = this.pane.getDockables();
        Tab[] allTabs = new Tab[dockables.length];
        int[] visibleToInvisible = this.getOriginalTabLocations();
        for (int i3 = 0; i3 < allTabs.length; ++i3) {
            allTabs[i3] = this.pane.getOnTab(dockables[i3]);
        }
        Tab[] result = new Tab[allTabs.length];
        int resultIndex = 0;
        Dockable selectedDockable = this.pane.getSelectedDockable();
        Tab selected = null;
        for (Tab tab : allTabs) {
            if (tab.getDockable() != selectedDockable) continue;
            selected = tab;
            break;
        }
        for (int i4 = 0; i4 < allTabs.length; ++i4) {
            if (selected != allTabs[i4]) continue;
            allTabs[i4] = null;
            result[resultIndex++] = selected;
            break;
        }
        int n = selectedIndex = selected == null ? -1 : this.indexOfTab(selected);
        if (selectedIndex == -1) {
            for (i2 = 0; i2 < visibleToInvisible.length; ++i2) {
                Tab tab;
                if (visibleToInvisible[i2] == -1 || (tab = allTabs[visibleToInvisible[i2]]) == null) continue;
                result[resultIndex++] = tab;
                allTabs[visibleToInvisible[i2]] = null;
            }
        } else {
            for (i2 = selectedIndex - 1; i2 >= 0; --i2) {
                Tab tab;
                if (visibleToInvisible[i2] == -1 || (tab = allTabs[visibleToInvisible[i2]]) == null) continue;
                result[resultIndex++] = tab;
                allTabs[visibleToInvisible[i2]] = null;
            }
            for (i2 = selectedIndex + 1; i2 < visibleToInvisible.length; ++i2) {
                Tab tab;
                if (visibleToInvisible[i2] == -1 || (tab = allTabs[visibleToInvisible[i2]]) == null) continue;
                result[resultIndex++] = tab;
                allTabs[visibleToInvisible[i2]] = null;
            }
        }
        int leftMostVisible = -1;
        int rightMostVisible = -1;
        for (i = 0; i < allTabs.length; ++i) {
            if (allTabs[i] != null) continue;
            leftMostVisible = i;
            break;
        }
        for (i = allTabs.length - 1; i >= 0; --i) {
            if (allTabs[i] != null) continue;
            rightMostVisible = i;
            break;
        }
        for (i = leftMostVisible + 1; i < rightMostVisible; ++i) {
            if (allTabs[i] == null) continue;
            result[resultIndex++] = allTabs[i];
            allTabs[i] = null;
        }
        for (i = leftMostVisible - 1; i >= 0; --i) {
            if (allTabs[i] == null) continue;
            result[resultIndex++] = allTabs[i];
            allTabs[i] = null;
        }
        for (i = Math.max(0, rightMostVisible); i < allTabs.length; ++i) {
            if (allTabs[i] == null) continue;
            result[resultIndex++] = allTabs[i];
            allTabs[i] = null;
        }
        return result;
    }

    public int[] getOriginalTabLocations() {
        TabPane pane = this.getPane();
        if (pane == null) {
            throw new IllegalStateException("no TabPane available");
        }
        Tab[] tabs = this.getTabs();
        Dockable[] dockables = pane.getDockables();
        int[] locations = new int[tabs.length];
        int index = 0;
        block0: for (int i = 0; i < tabs.length; ++i) {
            Dockable check = tabs[i].getDockable();
            locations[i] = -1;
            for (int j = 0; j < dockables.length; ++j) {
                if (dockables[index] == check) {
                    locations[i] = index;
                    continue block0;
                }
                index = (index + 1) % dockables.length;
            }
        }
        return locations;
    }

    public Tab[] getDockableTabMap() {
        TabPane pane = this.getPane();
        if (pane == null) {
            throw new IllegalStateException("missing the TabPane");
        }
        Tab[] tabs = this.getTabs();
        Dockable[] dockables = pane.getDockables();
        Tab[] result = new Tab[dockables.length];
        int index = 0;
        block0: for (int i = 0; i < tabs.length; ++i) {
            Dockable check = tabs[i].getDockable();
            for (int j = 0; j < dockables.length; ++j) {
                if (dockables[index] == check) {
                    result[index] = tabs[i];
                    continue block0;
                }
                index = (index + 1) % dockables.length;
            }
        }
        return result;
    }

    public void insertTab(Tab tab, int index) {
        if (tab == null) {
            throw new IllegalArgumentException("tab must not be null");
        }
        this.tabs.add(index, tab);
        tab.setOrientation(this.getOrientation());
    }

    public boolean removeTab(Tab tab) {
        return this.tabs.remove(tab);
    }

    public Tab removeTab(int index) {
        return this.tabs.remove(index);
    }

    public void removeAllTabs() {
        this.tabs.clear();
    }

    public abstract void doLayout();

    @Override
    public void setLayout(Size size) {
        if (size instanceof TabsSize) {
            Tab[] current;
            Tab[] tabs = ((TabsSize)size).getTabs();
            if (tabs.length == (current = this.getTabs()).length) {
                boolean same = true;
                for (int i = 0; i < tabs.length && same; ++i) {
                    same = tabs[i] == current[i];
                }
                if (same) {
                    return;
                }
            }
            this.removeAllTabs();
            for (Tab tab : tabs) {
                tab = this.pane.putOnTab(tab.getDockable());
                this.insertTab(tab);
            }
        } else {
            throw new IllegalArgumentException("not a size created by this block");
        }
    }

    public boolean isVisible() {
        return true;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.bounds.setBounds(x, y, width, height);
        this.doLayout();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    protected class TabsSize
    extends Size {
        private Tab[] tabs;

        public TabsSize(Size.Type type, Dimension size, Tab[] tabs, double score) {
            super(type, size, score);
            this.tabs = tabs;
        }

        public Tab[] getTabs() {
            return this.tabs;
        }

        public int getTabCount() {
            return this.tabs.length;
        }

        @Override
        public String toString() {
            return "[width=" + this.getWidth() + ", height=" + this.getHeight() + ", tabs=" + Arrays.toString(this.tabs) + "]";
        }
    }
}

