/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.icon;

import bibliothek.gui.dock.station.stack.tab.TabMenu;
import bibliothek.gui.dock.station.stack.tab.TabMenuDockIcon;
import bibliothek.gui.dock.station.stack.tab.TabMenuListener;
import bibliothek.gui.dock.themes.icon.TabMenuOverflowIcon;
import bibliothek.gui.dock.util.icon.DockIcon;
import bibliothek.gui.dock.util.icon.DockIconBridge;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;

public class TabMenuOverflowIconBridge
implements DockIconBridge {
    public static final String ICON_KEY = "dock.menu.overflow";
    private Set<TabMenuDockIcon> menus = new HashSet<TabMenuDockIcon>();
    private Set<TabMenuDockIcon> protectedMenus = new HashSet<TabMenuDockIcon>();
    private TabMenuListener listener = new Listener();

    @Override
    public void add(String id, DockIcon icon) {
        if (id.equals(ICON_KEY)) {
            TabMenuDockIcon menu = (TabMenuDockIcon)icon;
            this.menus.add(menu);
            menu.getMenu().addTabMenuListener(this.listener);
        }
    }

    @Override
    public void remove(String id, DockIcon icon) {
        if (id.equals(ICON_KEY)) {
            TabMenuDockIcon menu = (TabMenuDockIcon)icon;
            this.menus.remove(menu);
            this.protectedMenus.remove(menu);
            menu.getMenu().removeTabMenuListener(this.listener);
            icon.set(null);
        }
    }

    @Override
    public void set(String id, Icon value, DockIcon icon) {
        if (id.equals(ICON_KEY)) {
            if (value == null) {
                value = this.createIcon(((TabMenuDockIcon)icon).getMenu());
                this.protectedMenus.remove(icon);
            } else {
                this.protectedMenus.add((TabMenuDockIcon)icon);
            }
            icon.set(value);
        }
    }

    private void update(TabMenu menu) {
        for (TabMenuDockIcon icon : this.menus) {
            if (icon.getMenu() != menu || this.protectedMenus.contains(icon)) continue;
            icon.set(this.createIcon(menu));
            return;
        }
    }

    protected Icon createIcon(TabMenu menu) {
        return new TabMenuOverflowIcon(menu.getDockableCount());
    }

    private class Listener
    implements TabMenuListener {
        private Listener() {
        }

        @Override
        public void dockablesAdded(TabMenu source, int offset, int length) {
            TabMenuOverflowIconBridge.this.update(source);
        }

        @Override
        public void dockablesRemoved(TabMenu source, int offset, int length) {
            TabMenuOverflowIconBridge.this.update(source);
        }
    }
}

