/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.AbstractWindowProvider;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class FocusedWindowProvider
extends AbstractWindowProvider {
    private List<Window> history = new LinkedList<Window>();
    private Set<Window> monitored = new HashSet<Window>();
    private Window current;
    private WindowFocusListener listener = new WindowFocusListener(){

        @Override
        public void windowLostFocus(WindowEvent e) {
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            FocusedWindowProvider.this.current = e.getWindow();
            FocusedWindowProvider.this.fireWindowChanged(FocusedWindowProvider.this.current);
            FocusedWindowProvider.this.history.remove(FocusedWindowProvider.this.current);
            FocusedWindowProvider.this.history.add(FocusedWindowProvider.this.current);
        }
    };

    @Override
    public Window searchWindow() {
        return this.current;
    }

    public void add(Window window) {
        if (this.monitored.add(window)) {
            window.addWindowFocusListener(this.listener);
            if (window.isActive()) {
                this.current = window;
                this.fireWindowChanged(window);
                this.history.add(this.current);
            } else {
                this.history.add(0, window);
            }
        }
    }

    public void remove(Window window) {
        this.monitored.remove(window);
        this.history.remove(window);
        window.removeWindowFocusListener(this.listener);
        if (this.current == window) {
            this.current = null;
            if (this.history.size() > 0) {
                this.current = this.history.get(this.history.size() - 1);
            }
            this.fireWindowChanged(this.current);
        }
    }
}

