/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.util;

import bibliothek.gui.dock.support.util.ApplicationResource;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;

public class ApplicationResourceManager {
    private Map<String, ApplicationResource> resources = new HashMap<String, ApplicationResource>();
    private Map<String, Object> buffer = new HashMap<String, Object>();

    public void put(String name, ApplicationResource resource) throws IOException {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (resource == null) {
            throw new NullPointerException("resource must not be null");
        }
        this.resources.put(name, resource);
        Object buffered = this.buffer.get(name);
        if (buffered != null) {
            if (buffered instanceof byte[]) {
                ByteArrayInputStream in = new ByteArrayInputStream((byte[])buffered);
                DataInputStream data = new DataInputStream(in);
                resource.read(data);
                data.close();
            }
            if (buffered instanceof XElement) {
                resource.readXML((XElement)buffered);
            }
        }
    }

    public void remove(String name) {
        this.resources.remove(name);
    }

    public void writeStream(DataOutputStream out) throws IOException {
        Version.write((DataOutputStream)out, (Version)Version.VERSION_1_0_4);
        out.writeInt(this.resources.size());
        for (Map.Entry<String, ApplicationResource> resource : this.resources.entrySet()) {
            out.writeUTF(resource.getKey());
            ByteArrayOutputStream array = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(array);
            resource.getValue().write(data);
            data.close();
            out.writeInt(array.size());
            array.writeTo(out);
        }
        for (Map.Entry<String, Object> unknownResource : this.buffer.entrySet()) {
            Object value = unknownResource.getValue();
            if (!(value instanceof byte[])) continue;
            byte[] array = (byte[])value;
            out.writeUTF(unknownResource.getKey());
            out.writeInt(array.length);
            out.write(array);
        }
    }

    public void readStream(DataInputStream in) throws IOException {
        Version version = Version.read((DataInputStream)in);
        version.checkCurrent();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            int length = in.readInt();
            byte[] input = new byte[length];
            in.readFully(input);
            ApplicationResource resource = this.resources.get(key);
            if (resource != null) {
                ByteArrayInputStream array = new ByteArrayInputStream(input);
                DataInputStream data = new DataInputStream(array);
                resource.read(data);
                data.close();
                continue;
            }
            this.buffer.put(key, input);
        }
    }

    public void writeXML(XElement element) {
        for (Map.Entry<String, ApplicationResource> resource : this.resources.entrySet()) {
            XElement xresource = element.addElement("resource");
            xresource.addString("name", resource.getKey());
            resource.getValue().writeXML(xresource);
        }
        for (Map.Entry<String, Object> unknownResource : this.buffer.entrySet()) {
            Object value = unknownResource.getValue();
            if (!(value instanceof XElement)) continue;
            XElement xvalue = (XElement)value;
            element.addElement(xvalue);
        }
    }

    public void readXML(XElement element) {
        for (XElement xresource : element.getElements("resource")) {
            String name = xresource.getString("name");
            ApplicationResource resource = this.resources.get(name);
            if (resource != null) {
                resource.readXML(xresource);
                continue;
            }
            this.buffer.put(name, xresource);
        }
    }

    public void writeFile(File file) throws IOException {
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            this.writeStream(out);
        }
    }

    public void readFile(File file) throws IOException {
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));){
            this.readStream(in);
        }
    }

    public byte[] writeArray() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(out);
        this.writeStream(data);
        data.close();
        return out.toByteArray();
    }

    public void readArray(byte[] array) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(array);
        DataInputStream data = new DataInputStream(in);
        this.readStream(data);
        data.close();
    }

    public void writePreferences() throws IOException {
        Preferences preference = Preferences.userNodeForPackage(ApplicationResourceManager.class);
        preference.putByteArray("content", this.writeArray());
    }

    public void readPreferences() throws IOException {
        Preferences preference = Preferences.userNodeForPackage(ApplicationResourceManager.class);
        byte[] array = preference.getByteArray("content", null);
        if (array != null) {
            this.readArray(array);
        }
    }
}

