/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ZigguratSampler;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.ArgumentUtils;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public final class ExponentialDistribution
extends AbstractContinuousDistribution {
    private static final double SUPPORT_LO = 0.0;
    private static final double SUPPORT_HI = Double.POSITIVE_INFINITY;
    private static final double LN_2 = 0.6931471805599453;
    private final double mean;
    private final double logMean;

    private ExponentialDistribution(double mean) {
        this.mean = mean;
        this.logMean = Math.log(mean);
    }

    public static ExponentialDistribution of(double mean) {
        if (mean <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", mean);
        }
        return new ExponentialDistribution(mean);
    }

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return Math.exp(-x / this.mean) / this.mean;
    }

    @Override
    public double logDensity(double x) {
        if (x < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return -x / this.mean - this.logMean;
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return -Math.expm1(-x / this.mean);
    }

    @Override
    public double survivalProbability(double x) {
        if (x <= 0.0) {
            return 1.0;
        }
        return Math.exp(-x / this.mean);
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return 0.0 - this.mean * Math.log1p(-p);
    }

    @Override
    public double inverseSurvivalProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return 0.0 - this.mean * Math.log(p);
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        return this.mean * this.mean;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    double getMedian() {
        return this.mean * 0.6931471805599453;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((ZigguratSampler.Exponential)ZigguratSampler.Exponential.of((UniformRandomProvider)rng, (double)this.getMean())).sample();
    }
}

