/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.trajstat.forms;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.legend.GroupNode;
import org.meteoinfo.geo.legend.LayerNode;
import org.meteoinfo.geo.plugin.IApplication;
import org.meteoinfo.geometry.geoprocess.GeoComputation;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.table.Field;
import org.meteoinfo.ui.CheckTreeManager;
import org.meteoinfo.ui.CheckTreeSelectionModel;

public class FrmPSCF
extends JDialog {
    private IApplication app;
    CheckTreeManager checkTreeManager;
    private JButton jButton_CalPSCF;
    private JButton jButton_GetMij;
    private JButton jButton_GetNij;
    private JButton jButton_Weight;
    private JButton jButton_WeightPSCF;
    private JCheckBox jCheckBox_ThresholdHeight;
    private JComboBox jComboBox_Field;
    private JComboBox jComboBox_PSCFLayer;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane2;
    private JTextField jTextField_Criterion;
    private JTextField jTextField_EndPoint;
    private JTextField jTextField_Missing;
    private JTextField jTextField_ReduceRatio;
    private JTextField jTextField_ReduceRatio_Traj;
    private JTextField jTextField_ThresholdHeight;
    private JTextField jTextField_TrajNum;
    private JTree jTree_TrajLayers;

    public FrmPSCF(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.app = (IApplication)parent;
        this.jTextField_ThresholdHeight.setEnabled(false);
        DefaultMutableTreeNode layersTN = new DefaultMutableTreeNode("Trajectory", true);
        GroupNode gNode = this.app.getMapDocument().getActiveMapFrame().getGroupByName("Trajectory");
        for (LayerNode lNode : gNode.getLayers()) {
            layersTN.insert(new DefaultMutableTreeNode(lNode.getMapLayer()), 0);
        }
        DefaultTreeModel model = new DefaultTreeModel(layersTN);
        this.jTree_TrajLayers.setModel(model);
        this.checkTreeManager = new CheckTreeManager(this.jTree_TrajLayers);
        TreePath path = this.jTree_TrajLayers.getPathForRow(1);
        CheckTreeSelectionModel selModel = this.checkTreeManager.getSelectionModel();
        selModel.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FrmPSCF.this.onSelectionValueChanged(e);
            }
        });
        selModel.addSelectionPath(path);
        this.getFileds();
        GroupNode pNode = this.app.getMapDocument().getActiveMapFrame().getGroupByName("PSCF");
        this.jComboBox_PSCFLayer.removeAllItems();
        for (LayerNode lNode : pNode.getLayers()) {
            this.jComboBox_PSCFLayer.addItem(lNode.getMapLayer());
        }
    }

    private void getFileds() {
        TreePath[] checkedPaths = this.checkTreeManager.getSelectionModel().getSelectionPaths();
        if (checkedPaths == null) {
            return;
        }
        VectorLayer layer = null;
        for (TreePath path : checkedPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node.getChildCount() <= 0) {
                layer = (VectorLayer)node.getUserObject();
                break;
            }
            DefaultMutableTreeNode cnode = (DefaultMutableTreeNode)node.getChildAt(0);
            layer = (VectorLayer)cnode.getUserObject();
        }
        if (layer != null) {
            this.jComboBox_Field.removeAllItems();
            for (Field field : layer.getFields()) {
                if (!field.isNumeric()) continue;
                this.jComboBox_Field.addItem(field.getColumnName());
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox_PSCFLayer = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBox_Field = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jTextField_Criterion = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextField_Missing = new JTextField();
        this.jPanel1 = new JPanel();
        this.jButton_GetNij = new JButton();
        this.jButton_GetMij = new JButton();
        this.jButton_CalPSCF = new JButton();
        this.jButton_WeightPSCF = new JButton();
        this.jCheckBox_ThresholdHeight = new JCheckBox();
        this.jTextField_ThresholdHeight = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.jTree_TrajLayers = new JTree();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jTextField_EndPoint = new JTextField();
        this.jLabel6 = new JLabel();
        this.jTextField_ReduceRatio = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jTextField_TrajNum = new JTextField();
        this.jLabel8 = new JLabel();
        this.jTextField_ReduceRatio_Traj = new JTextField();
        this.jButton_Weight = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("PSCF Analysis");
        this.jLabel1.setText("PSCF Layer:");
        this.jComboBox_PSCFLayer.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel2.setText("Field:");
        this.jComboBox_Field.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel3.setText("Criterion:");
        this.jTextField_Criterion.setText("0");
        this.jLabel4.setText("Missing:");
        this.jTextField_Missing.setText("0");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("PSCF Calculation"));
        this.jButton_GetNij.setText("Get Nij");
        this.jButton_GetNij.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPSCF.this.jButton_GetNijActionPerformed(evt);
            }
        });
        this.jButton_GetMij.setText("Get Mij");
        this.jButton_GetMij.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPSCF.this.jButton_GetMijActionPerformed(evt);
            }
        });
        this.jButton_CalPSCF.setText("Cal PSCF");
        this.jButton_CalPSCF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPSCF.this.jButton_CalPSCFActionPerformed(evt);
            }
        });
        this.jButton_WeightPSCF.setText("Weight PSCF");
        this.jButton_WeightPSCF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPSCF.this.jButton_WeightPSCFActionPerformed(evt);
            }
        });
        this.jCheckBox_ThresholdHeight.setText("Threshold height (m)");
        this.jCheckBox_ThresholdHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPSCF.this.jCheckBox_ThresholdHeightActionPerformed(evt);
            }
        });
        this.jTextField_ThresholdHeight.setText("2000");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBox_ThresholdHeight, -2, 145, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_ThresholdHeight, -2, 98, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton_CalPSCF, -2, 104, -2).addComponent(this.jButton_GetNij, -2, 104, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton_GetMij, GroupLayout.Alignment.TRAILING, -2, 104, -2).addComponent(this.jButton_WeightPSCF, GroupLayout.Alignment.TRAILING)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_GetNij).addComponent(this.jButton_GetMij)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_CalPSCF).addComponent(this.jButton_WeightPSCF)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox_ThresholdHeight).addComponent(this.jTextField_ThresholdHeight, -2, -1, -2)).addContainerGap(8, Short.MAX_VALUE)));
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("colors");
        DefaultMutableTreeNode treeNode2 = new DefaultMutableTreeNode("blue");
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("violet");
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("red");
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("yellow");
        treeNode1.add(treeNode2);
        this.jTree_TrajLayers.setModel(new DefaultTreeModel(treeNode1));
        this.jScrollPane2.setViewportView(this.jTree_TrajLayers);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Weight by endpoint number"));
        this.jLabel5.setText("End Point:");
        this.jTextField_EndPoint.setText("80;20;10");
        this.jLabel6.setText("Reduce Ratio:");
        this.jTextField_ReduceRatio.setText("0.7;0.42;0.05");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField_EndPoint).addComponent(this.jTextField_ReduceRatio)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextField_EndPoint, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextField_ReduceRatio, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Weight by trajectory number"));
        this.jLabel7.setText("Trajectory:");
        this.jTextField_TrajNum.setText("3;1");
        this.jTextField_TrajNum.setToolTipText("");
        this.jLabel8.setText("Reduce Ratio:");
        this.jTextField_ReduceRatio_Traj.setText("0.5;0.2");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel8).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField_TrajNum).addComponent(this.jTextField_ReduceRatio_Traj, -1, 164, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextField_TrajNum, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jTextField_ReduceRatio_Traj, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton_Weight.setText("Weight");
        this.jButton_Weight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmPSCF.this.jButton_WeightActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_PSCFLayer, -2, 164, -2).addGap(34, 34, 34).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Field, -2, 204, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_Criterion, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_Missing)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 268, -2).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton_Weight, -2, 110, -2).addGap(83, 83, 83)))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox_PSCFLayer, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jComboBox_Field, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextField_Criterion, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jTextField_Missing, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton_Weight))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.jPanel3, -2, -1, -2)).addContainerGap(14, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton_GetNijActionPerformed(ActionEvent evt) {
        double missingValue = Double.parseDouble(this.jTextField_Missing.getText());
        if (this.jCheckBox_ThresholdHeight.isSelected()) {
            double thresholdHeight = Double.parseDouble(this.jTextField_ThresholdHeight.getText());
            this.getEndPointsInCell("Nij", 0.0, missingValue, thresholdHeight);
        } else {
            this.getEndPointsInCell("Nij", 0.0, missingValue);
        }
    }

    private void jButton_GetMijActionPerformed(ActionEvent evt) {
        double criterion = Double.parseDouble(this.jTextField_Criterion.getText());
        double missingValue = Double.parseDouble(this.jTextField_Missing.getText());
        if (this.jCheckBox_ThresholdHeight.isSelected()) {
            double thresholdHeight = Double.parseDouble(this.jTextField_ThresholdHeight.getText());
            this.getEndPointsInCell("Mij", criterion, missingValue, thresholdHeight);
        } else {
            this.getEndPointsInCell("Mij", criterion, missingValue);
        }
    }

    private void jButton_CalPSCFActionPerformed(ActionEvent evt) {
        VectorLayer aLayer = (VectorLayer)this.jComboBox_PSCFLayer.getSelectedItem();
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (int i = 0; i < aLayer.getShapeNum(); ++i) {
            double pscf;
            int Nij = Integer.parseInt(aLayer.getCellValue("Nij", i).toString());
            if (Nij > 0) {
                int Mij = Integer.parseInt(aLayer.getCellValue("Mij", i).toString());
                pscf = (double)Mij / (double)Nij;
            } else {
                pscf = 0.0;
            }
            aLayer.editCellValue("PSCF", i, (Object)pscf);
        }
        aLayer.getAttributeTable().save();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButton_WeightPSCFActionPerformed(ActionEvent evt) {
        VectorLayer aLayer = (VectorLayer)this.jComboBox_PSCFLayer.getSelectedItem();
        String[] endPoints = this.jTextField_EndPoint.getText().split(";");
        String[] reduceRatios = this.jTextField_ReduceRatio.getText().split(";");
        int epNum = endPoints.length;
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (int i = 0; i < aLayer.getShapeNum(); ++i) {
            double pscf;
            int Nij = Integer.parseInt(aLayer.getCellValue("Nij", i).toString());
            double wpscf = pscf = Double.parseDouble(aLayer.getCellValue("PSCF", i).toString());
            for (int j = 0; j <= epNum - 1; ++j) {
                if (j == epNum - 1) {
                    if (Nij > Integer.parseInt(endPoints[j])) continue;
                    wpscf = pscf * Double.parseDouble(reduceRatios[j]);
                    continue;
                }
                if (Nij > Integer.parseInt(endPoints[j]) || Nij <= Integer.parseInt(endPoints[j + 1])) continue;
                wpscf = pscf * Double.parseDouble(reduceRatios[j]);
            }
            aLayer.editCellValue("WPSCF", i, (Object)wpscf);
        }
        aLayer.getAttributeTable().save();
        aLayer.updateLegendIndexes();
        this.app.getMapView().paintLayers();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButton_WeightActionPerformed(ActionEvent evt) {
        VectorLayer aLayer = (VectorLayer)this.jComboBox_PSCFLayer.getSelectedItem();
        String[] endPoints = this.jTextField_TrajNum.getText().split(";");
        String[] reduceRatios = this.jTextField_ReduceRatio_Traj.getText().split(";");
        int epNum = endPoints.length;
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (int i = 0; i < aLayer.getShapeNum(); ++i) {
            double pscf;
            int tNij = Integer.parseInt(aLayer.getCellValue("N_Traj", i).toString());
            double wpscf = pscf = Double.parseDouble(aLayer.getCellValue("WPSCF", i).toString());
            for (int j = 0; j <= epNum - 1; ++j) {
                if (j == epNum - 1) {
                    if (tNij > Integer.parseInt(endPoints[j])) continue;
                    wpscf = pscf * Double.parseDouble(reduceRatios[j]);
                    continue;
                }
                if (tNij > Integer.parseInt(endPoints[j]) || tNij <= Integer.parseInt(endPoints[j + 1])) continue;
                wpscf = pscf * Double.parseDouble(reduceRatios[j]);
            }
            aLayer.editCellValue("WPSCF", i, (Object)wpscf);
        }
        aLayer.getAttributeTable().save();
        aLayer.updateLegendIndexes();
        this.app.getMapView().paintLayers();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jCheckBox_ThresholdHeightActionPerformed(ActionEvent evt) {
        this.jTextField_ThresholdHeight.setEnabled(this.jCheckBox_ThresholdHeight.isSelected());
    }

    private void getEndPointsInCell(final String aType, final double aCriterion, final double aNData) {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                int i;
                VectorLayer PSCFLayer = (VectorLayer)FrmPSCF.this.jComboBox_PSCFLayer.getSelectedItem();
                TreePath[] checkedPaths = FrmPSCF.this.checkTreeManager.getSelectionModel().getSelectionPaths();
                if (checkedPaths == null) {
                    JOptionPane.showMessageDialog(null, "There is no trajectory layer was selected!");
                    return "";
                }
                ArrayList<VectorLayer> layers = new ArrayList<VectorLayer>();
                for (TreePath path : checkedPaths) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node.getChildCount() > 0) {
                        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
                            DefaultMutableTreeNode cnode = (DefaultMutableTreeNode)node.getChildAt(i2);
                            layers.add((VectorLayer)cnode.getUserObject());
                        }
                        continue;
                    }
                    layers.add((VectorLayer)node.getUserObject());
                    break;
                }
                FrmPSCF.this.setCursor(Cursor.getPredefinedCursor(3));
                FrmPSCF.this.app.getProgressBar().setVisible(true);
                FrmPSCF.this.app.getProgressBar().setValue(0);
                FrmPSCF.this.app.getProgressBarLabel().setVisible(true);
                FrmPSCF.this.app.getProgressBarLabel().setText("...");
                boolean usingCriterion = false;
                if (aType.equals("Mij")) {
                    usingCriterion = true;
                }
                int[] Nijs = new int[PSCFLayer.getShapeNum()];
                int[] TNijs = new int[PSCFLayer.getShapeNum()];
                for (i = 0; i < Nijs.length; ++i) {
                    Nijs[i] = 0;
                    TNijs[i] = 0;
                }
                ArrayList<Integer> cellIdx = new ArrayList<Integer>();
                String fieldName = FrmPSCF.this.jComboBox_Field.getSelectedItem().toString();
                for (VectorLayer tLayer : layers) {
                    FrmPSCF.this.app.getProgressBarLabel().setText(tLayer.getLayerName());
                    int dataFldIdx = tLayer.getFieldIdxByName(fieldName);
                    for (i = 0; i < tLayer.getShapeNum(); ++i) {
                        double value = Double.parseDouble(tLayer.getCellValue(dataFldIdx, i).toString());
                        if (MIMath.doubleEquals((double)value, (double)aNData) || usingCriterion && value < aCriterion) continue;
                        cellIdx.clear();
                        PolylineZShape aPLZ = (PolylineZShape)tLayer.getShapes().get(i);
                        block5: for (int p = 0; p < aPLZ.getPointNum(); ++p) {
                            PointD aPoint = new PointD(((PointD)aPLZ.getPoints().get((int)p)).X, ((PointD)aPLZ.getPoints().get((int)p)).Y);
                            for (int s = 0; s < PSCFLayer.getShapeNum(); ++s) {
                                PolygonShape aPGS = (PolygonShape)PSCFLayer.getShapes().get(s);
                                if (!GeoComputation.pointInPolygon((List)aPGS.getPoints(), (PointD)aPoint)) continue;
                                int n = s;
                                Nijs[n] = Nijs[n] + 1;
                                if (cellIdx.contains(s)) continue block5;
                                int n2 = s;
                                TNijs[n2] = TNijs[n2] + 1;
                                cellIdx.add(s);
                                continue block5;
                            }
                        }
                        FrmPSCF.this.app.getProgressBar().setValue((int)((float)(i + 1) / (float)tLayer.getShapeNum() * 100.0f));
                    }
                }
                for (i = 0; i < PSCFLayer.getShapeNum(); ++i) {
                    PSCFLayer.editCellValue(aType, i, (Object)Nijs[i]);
                    if (usingCriterion) continue;
                    PSCFLayer.editCellValue("N_Traj", i, (Object)TNijs[i]);
                }
                PSCFLayer.getAttributeTable().save();
                return "";
            }

            @Override
            protected void done() {
                FrmPSCF.this.app.getProgressBar().setVisible(false);
                FrmPSCF.this.app.getProgressBarLabel().setVisible(false);
                FrmPSCF.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        worker.execute();
    }

    private void getEndPointsInCell(final String aType, final double aCriterion, final double aNData, final double thresholdHeight) {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                int i;
                VectorLayer PSCFLayer = (VectorLayer)FrmPSCF.this.jComboBox_PSCFLayer.getSelectedItem();
                TreePath[] checkedPaths = FrmPSCF.this.checkTreeManager.getSelectionModel().getSelectionPaths();
                if (checkedPaths == null) {
                    JOptionPane.showMessageDialog(null, "There is no trajectory layer was selected!");
                    return "";
                }
                ArrayList<VectorLayer> layers = new ArrayList<VectorLayer>();
                for (TreePath path : checkedPaths) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node.getChildCount() > 0) {
                        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
                            DefaultMutableTreeNode cnode = (DefaultMutableTreeNode)node.getChildAt(i2);
                            layers.add((VectorLayer)cnode.getUserObject());
                        }
                        continue;
                    }
                    layers.add((VectorLayer)node.getUserObject());
                    break;
                }
                FrmPSCF.this.setCursor(Cursor.getPredefinedCursor(3));
                FrmPSCF.this.app.getProgressBar().setVisible(true);
                FrmPSCF.this.app.getProgressBar().setValue(0);
                FrmPSCF.this.app.getProgressBarLabel().setVisible(true);
                FrmPSCF.this.app.getProgressBarLabel().setText("...");
                boolean usingCriterion = false;
                if (aType.equals("Mij")) {
                    usingCriterion = true;
                }
                int[] Nijs = new int[PSCFLayer.getShapeNum()];
                int[] TNijs = new int[PSCFLayer.getShapeNum()];
                for (i = 0; i < Nijs.length; ++i) {
                    Nijs[i] = 0;
                    TNijs[i] = 0;
                }
                ArrayList<Integer> cellIdx = new ArrayList<Integer>();
                String fieldName = FrmPSCF.this.jComboBox_Field.getSelectedItem().toString();
                for (VectorLayer tLayer : layers) {
                    FrmPSCF.this.app.getProgressBarLabel().setText(tLayer.getLayerName());
                    int dataFldIdx = tLayer.getFieldIdxByName(fieldName);
                    for (i = 0; i < tLayer.getShapeNum(); ++i) {
                        double value = Double.parseDouble(tLayer.getCellValue(dataFldIdx, i).toString());
                        if (MIMath.doubleEquals((double)value, (double)aNData) || usingCriterion && value < aCriterion) continue;
                        cellIdx.clear();
                        PolylineZShape aPLZ = (PolylineZShape)tLayer.getShapes().get(i);
                        block5: for (int p = 0; p < aPLZ.getPointNum(); ++p) {
                            PointZ aPoint = (PointZ)aPLZ.getPoints().get(p);
                            if (aPoint.Z > thresholdHeight) continue;
                            for (int s = 0; s < PSCFLayer.getShapeNum(); ++s) {
                                PolygonShape aPGS = (PolygonShape)PSCFLayer.getShapes().get(s);
                                if (!GeoComputation.pointInPolygon((List)aPGS.getPoints(), (PointD)aPoint)) continue;
                                int n = s;
                                Nijs[n] = Nijs[n] + 1;
                                if (cellIdx.contains(s)) continue block5;
                                int n2 = s;
                                TNijs[n2] = TNijs[n2] + 1;
                                cellIdx.add(s);
                                continue block5;
                            }
                        }
                        FrmPSCF.this.app.getProgressBar().setValue((int)((float)(i + 1) / (float)tLayer.getShapeNum() * 100.0f));
                    }
                }
                for (i = 0; i < PSCFLayer.getShapeNum(); ++i) {
                    PSCFLayer.editCellValue(aType, i, (Object)Nijs[i]);
                    if (usingCriterion) continue;
                    PSCFLayer.editCellValue("N_Traj", i, (Object)TNijs[i]);
                }
                PSCFLayer.getAttributeTable().save();
                return "";
            }

            @Override
            protected void done() {
                FrmPSCF.this.app.getProgressBar().setVisible(false);
                FrmPSCF.this.app.getProgressBarLabel().setVisible(false);
                FrmPSCF.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        worker.execute();
    }

    private void onSelectionValueChanged(TreeSelectionEvent evt) {
        this.getFileds();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmPSCF.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmPSCF.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmPSCF.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmPSCF.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmPSCF dialog = new FrmPSCF((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

