/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.util;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.geo.layer.RasterLayer;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geometry.geoprocess.GeoComputation;
import org.meteoinfo.geometry.geoprocess.GeometryUtil;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.StationModelShape;
import org.meteoinfo.geometry.shape.WindArrow;
import org.meteoinfo.geometry.shape.WindBarb;
import org.meteoinfo.math.interpolate.InterpUtil;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.math.ArrayUtil;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.ProjectionUtil;
import org.meteoinfo.projection.Reproject;
import org.meteoinfo.table.DataColumn;
import org.meteoinfo.table.DataRow;
import org.meteoinfo.table.DataTable;
import org.meteoinfo.table.Field;

public class GeoProjectionUtil {
    public static Object[] reprojectGrid(Array data, Array xx, Array yy, ProjectionInfo fromProj, ProjectionInfo toProj) throws InvalidRangeException {
        int i;
        int xnum = (int)xx.getSize();
        int ynum = (int)yy.getSize();
        Extent aExtent = ProjectionUtil.getProjectionExtent((ProjectionInfo)fromProj, (ProjectionInfo)toProj, (Array)xx, (Array)yy);
        double xDelt = (aExtent.maxX - aExtent.minX) / (double)(xnum - 1);
        double yDelt = (aExtent.maxY - aExtent.minY) / (double)(ynum - 1);
        Array rx = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{xnum});
        Array ry = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ynum});
        for (i = 0; i < xnum; ++i) {
            rx.setDouble(i, aExtent.minX + (double)i * xDelt);
        }
        for (i = 0; i < ynum; ++i) {
            ry.setDouble(i, aExtent.minY + (double)i * yDelt);
        }
        Array[] gxy = ArrayUtil.meshgrid((Array)xx, (Array)yy);
        Array[] pxy = Reproject.reproject((Array)gxy[0], (Array)gxy[1], (ProjectionInfo)fromProj, (ProjectionInfo)toProj);
        Array px = pxy[0];
        Array py = pxy[1];
        Array r = InterpUtil.interpolation_Nearest((Array)px, (Array)py, (Array)data, (Array)rx, (Array)ry, (double)Double.POSITIVE_INFINITY);
        PolygonShape polyshape = GeometryUtil.convexHull((Array)px, (Array)py);
        Array[] rxy = ArrayUtil.meshgrid((Array)rx, (Array)ry);
        ArrayList<PolygonShape> pss = new ArrayList<PolygonShape>();
        pss.add(polyshape);
        r = GeometryUtil.maskout((Array)r, (Array)rxy[0], (Array)rxy[1], pss);
        return new Object[]{r, rx, ry};
    }

    public static void projectLayer(VectorLayer oLayer, ProjectionInfo toProj) {
        double refLon = toProj.getCoordinateReferenceSystem().getProjection().getProjectionLongitudeDegrees();
        if ((refLon += 180.0) > 180.0) {
            refLon -= 360.0;
        } else if (refLon < -180.0) {
            refLon += 360.0;
        }
        GeoProjectionUtil.projectLayer(oLayer, toProj, refLon, true);
    }

    public static void projectLayer(VectorLayer oLayer, ProjectionInfo toProj, boolean projectLabels) {
        double refLon = toProj.getCoordinateReferenceSystem().getProjection().getProjectionLongitudeDegrees();
        if ((refLon += 180.0) > 180.0) {
            refLon -= 360.0;
        } else if (refLon < -180.0) {
            refLon += 360.0;
        }
        GeoProjectionUtil.projectLayer(oLayer, toProj, refLon, projectLabels);
    }

    public static void projectLayer(VectorLayer oLayer, ProjectionInfo toProj, double refCutLon) {
        GeoProjectionUtil.projectLayer(oLayer, toProj, refCutLon, true);
    }

    /*
     * Unable to fully structure code
     */
    public static void projectLayer(VectorLayer oLayer, ProjectionInfo toProj, double refCutLon, boolean projectLabels) {
        fromProj = oLayer.getOriginProjInfo();
        if (fromProj.equals(toProj)) {
            if (oLayer.isProjected()) {
                oLayer.getOriginData();
            }
            return;
        }
        if (oLayer.isProjected()) {
            oLayer.getOriginData();
        } else {
            oLayer.updateOriginData();
        }
        refLon = refCutLon;
        if (oLayer.getExtent().maxX > 180.0 && oLayer.getExtent().minX > refLon) {
            refLon += 360.0;
        }
        newPoints = new ArrayList<PointD>();
        lExtent = new Extent();
        aTable = new DataTable();
        for (DataColumn aDC : oLayer.getAttributeTable().getTable().getColumns()) {
            bDC = new Field(aDC.getColumnName(), aDC.getDataType());
            aTable.getColumns().add((DataColumn)bDC);
        }
        cutoff = toProj.getCutoff();
        switch (1.$SwitchMap$org$meteoinfo$geometry$shape$ShapeTypes[oLayer.getShapeType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                shapePoints = new ArrayList<PointShape>();
                newPoints.clear();
                block34: for (s = 0; s < oLayer.getShapeNum(); ++s) {
                    aPS = (PointShape)oLayer.getShapes().get(s);
                    if (fromProj.getProjectionName() != ProjectionNames.LongLat) ** GOTO lbl-1000
                    switch (1.$SwitchMap$org$meteoinfo$projection$ProjectionNames[toProj.getProjectionName().ordinal()]) {
                        case 1: {
                            if (aPS.getPoint().Y < (double)cutoff) {
                                continue block34;
                            }
                            ** GOTO lbl44
                        }
                        case 2: {
                            if (aPS.getPoint().Y < (double)cutoff) {
                                continue block34;
                            }
                            ** GOTO lbl44
                        }
                        case 3: {
                            if (aPS.getPoint().Y > (double)cutoff) {
                                continue block34;
                            }
                            ** GOTO lbl44
                        }
                        case 4: {
                            if (aPS.getPoint().Y > (double)cutoff || aPS.getPoint().Y < (double)(-cutoff)) continue block34;
                        }
lbl44:
                        // 5 sources

                        default: lbl-1000:
                        // 2 sources

                        {
                            if ((aPS = ProjectionUtil.projectPointShape((PointShape)aPS, (ProjectionInfo)fromProj, (ProjectionInfo)toProj)) == null) continue block34;
                            shapePoints.add(aPS);
                            newPoints.add(aPS.getPoint());
                            aDR = (DataRow)oLayer.getAttributeTable().getTable().getRows().get(s);
                            try {
                                aTable.addRow(aDR);
                                continue block34;
                            }
                            catch (Exception ex) {
                                Logger.getLogger(GeoProjectionUtil.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                }
                oLayer.setShapes(new ArrayList<E>(shapePoints));
                oLayer.setExtent(GeometryUtil.getPointsExtent(newPoints));
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                newPolylines = new ArrayList<PolylineShape>();
                for (s = 0; s < oLayer.getShapeNum(); ++s) {
                    aPLS = (PolylineShape)oLayer.getShapes().get(s);
                    plsList = new ArrayList<PolylineShape>();
                    if (fromProj.getProjectionName() == ProjectionNames.LongLat) {
                        switch (1.$SwitchMap$org$meteoinfo$projection$ProjectionNames[toProj.getProjectionName().ordinal()]) {
                            case 1: {
                                if (!(aPLS.getExtent().minY < (double)cutoff)) break;
                                aPLS = GeoComputation.clipPolylineShape_Lat((PolylineShape)aPLS, (double)cutoff, (boolean)true);
                                break;
                            }
                            case 2: {
                                if (!(aPLS.getExtent().minY < (double)cutoff)) break;
                                aPLS = GeoComputation.clipPolylineShape_Lat((PolylineShape)aPLS, (double)cutoff, (boolean)true);
                                break;
                            }
                            case 3: {
                                if (!(aPLS.getExtent().maxY > (double)cutoff)) break;
                                aPLS = GeoComputation.clipPolylineShape_Lat((PolylineShape)aPLS, (double)cutoff, (boolean)false);
                                break;
                            }
                            case 4: {
                                if (aPLS.getExtent().maxY > (double)cutoff) {
                                    aPLS = GeoComputation.clipPolylineShape_Lat((PolylineShape)aPLS, (double)cutoff, (boolean)false);
                                }
                                if (aPLS == null || !(aPLS.getExtent().minY < (double)(-cutoff))) break;
                                aPLS = GeoComputation.clipPolylineShape_Lat((PolylineShape)aPLS, (double)(-cutoff), (boolean)true);
                            }
                        }
                        if (aPLS == null) continue;
                        if (aPLS.getExtent().minX <= refLon && aPLS.getExtent().maxX >= refLon) {
                            switch (1.$SwitchMap$org$meteoinfo$projection$ProjectionNames[toProj.getProjectionName().ordinal()]) {
                                case 2: 
                                case 3: {
                                    plsList.add(aPLS);
                                    break;
                                }
                                default: {
                                    plsList.add(GeoComputation.clipPolylineShape_Lon((PolylineShape)aPLS, (double)refLon));
                                    break;
                                }
                            }
                        } else {
                            plsList.add(aPLS);
                        }
                    } else {
                        plsList.add(aPLS);
                    }
                    for (i = 0; i < plsList.size(); ++i) {
                        aPLS = (PolylineShape)plsList.get(i);
                        if ((aPLS = ProjectionUtil.projectPolylineShape((PolylineShape)aPLS, (ProjectionInfo)fromProj, (ProjectionInfo)toProj)) == null) continue;
                        newPolylines.add(aPLS);
                        aDR = (DataRow)oLayer.getAttributeTable().getTable().getRows().get(s);
                        try {
                            aTable.addRow(aDR);
                        }
                        catch (Exception ex) {
                            Logger.getLogger(GeoProjectionUtil.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        lExtent = s == 0 && i == 0 ? (Extent)aPLS.getExtent().clone() : MIMath.getLagerExtent((Extent)lExtent, (Extent)aPLS.getExtent());
                    }
                }
                oLayer.setShapes(new ArrayList<E>(newPolylines));
                newPolylines.clear();
                oLayer.setExtent(lExtent);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                newPolygons = new ArrayList<PolygonShape>();
                for (s = 0; s < oLayer.getShapeNum(); ++s) {
                    aDR = (DataRow)oLayer.getAttributeTable().getTable().getRows().get(s);
                    aPGS = (PolygonShape)oLayer.getShapes().get(s);
                    pgsList = new ArrayList<PolygonShape>();
                    if (fromProj.getProjectionName() == ProjectionNames.LongLat) {
                        switch (1.$SwitchMap$org$meteoinfo$projection$ProjectionNames[toProj.getProjectionName().ordinal()]) {
                            case 1: {
                                if (!(aPGS.getExtent().minY < (double)cutoff)) break;
                                aPGS = GeoComputation.clipPolygonShape_Lat((PolygonShape)aPGS, (double)cutoff, (boolean)true);
                                break;
                            }
                            case 2: {
                                if (!(aPGS.getExtent().minY < (double)cutoff)) break;
                                aPGS = GeoComputation.clipPolygonShape_Lat((PolygonShape)aPGS, (double)cutoff, (boolean)true);
                                break;
                            }
                            case 3: {
                                if (!(aPGS.getExtent().maxY > (double)cutoff)) break;
                                aPGS = GeoComputation.clipPolygonShape_Lat((PolygonShape)aPGS, (double)cutoff, (boolean)false);
                                break;
                            }
                            case 4: {
                                if (aPGS.getExtent().maxY > (double)cutoff) {
                                    aPGS = GeoComputation.clipPolygonShape_Lat((PolygonShape)aPGS, (double)cutoff, (boolean)false);
                                }
                                if (!(aPGS.getExtent().minY < (double)(-cutoff))) break;
                                aPGS = GeoComputation.clipPolygonShape_Lat((PolygonShape)aPGS, (double)(-cutoff), (boolean)true);
                            }
                        }
                        if (aPGS == null) continue;
                        if (aPGS.getExtent().minX <= refLon && aPGS.getExtent().maxX >= refLon) {
                            switch (1.$SwitchMap$org$meteoinfo$projection$ProjectionNames[toProj.getProjectionName().ordinal()]) {
                                case 2: 
                                case 3: {
                                    pgsList.add(aPGS);
                                    break;
                                }
                                default: {
                                    pgsList.add(GeoComputation.clipPolygonShape_Lon((PolygonShape)aPGS, (double)refLon));
                                    break;
                                }
                            }
                        } else {
                            pgsList.add(aPGS);
                        }
                    } else {
                        pgsList.add(aPGS);
                    }
                    for (i = 0; i < pgsList.size(); ++i) {
                        aPGS = (PolygonShape)pgsList.get(i);
                        if ((aPGS = ProjectionUtil.projectPolygonShape((PolygonShape)aPGS, (ProjectionInfo)fromProj, (ProjectionInfo)toProj)) == null) continue;
                        newPolygons.add(aPGS);
                        aTable.getRows().add((Object)aDR);
                        lExtent = s == 0 ? (Extent)aPGS.getExtent().clone() : MIMath.getLagerExtent((Extent)lExtent, (Extent)aPGS.getExtent());
                    }
                }
                oLayer.setShapes(new ArrayList<E>(newPolygons));
                newPolygons.clear();
                oLayer.setExtent(lExtent);
            }
        }
        oLayer.getAttributeTable().setTable(aTable);
        oLayer.setProjInfo(toProj);
        if (oLayer.getLabelPoints().size() > 0) {
            if (projectLabels) {
                oLayer.setLabelPoints(ProjectionUtil.projectGraphic(oLayer.getLabelPoints(), (ProjectionInfo)fromProj, (ProjectionInfo)toProj));
            } else {
                oLayer.setLabelPoints(new ArrayList<Graphic>(oLayer.getLabelPoints()));
            }
        }
    }

    public static GridArray project(GridArray gridArray, ProjectionInfo fromProj, ProjectionInfo toProj) throws InvalidRangeException {
        Array xx = ArrayUtil.array((Object)gridArray.xArray);
        Array yy = ArrayUtil.array((Object)gridArray.yArray);
        Object[] r = GeoProjectionUtil.reprojectGrid(gridArray.getData(), xx, yy, fromProj, toProj);
        GridArray rdata = new GridArray((Array)r[0], (Array)r[1], (Array)r[2], (Number)gridArray.missingValue);
        rdata.projInfo = toProj;
        return rdata;
    }

    public static void projectLayer(RasterLayer oLayer, ProjectionInfo toProj) {
        try {
            if (oLayer.getProjInfo().toProj4String().equals(toProj.toProj4String())) {
                if (oLayer.isProjected()) {
                    oLayer.getOriginData();
                    oLayer.updateGridData();
                    if (oLayer.getLegendScheme().getBreakNum() < 50) {
                        oLayer.updateImage();
                    } else {
                        oLayer.setPaletteByLegend();
                    }
                }
                return;
            }
            if (!oLayer.isProjected()) {
                oLayer.updateOriginData();
            } else {
                oLayer.getOriginData();
            }
            oLayer.setGridData(GeoProjectionUtil.project(oLayer.getGridData(), oLayer.getProjInfo(), toProj));
            oLayer.updateImage(oLayer.getLegendScheme());
            oLayer.setProjInfo(toProj);
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(GeoProjectionUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VectorLayer projectLayerAngle(VectorLayer oLayer, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<PointD> newPoints = new ArrayList<PointD>();
        VectorLayer aLayer = (VectorLayer)oLayer.clone();
        DataTable aTable = new DataTable();
        for (DataColumn aDC : oLayer.getAttributeTable().getTable().getColumns()) {
            Field bDC = new Field(aDC.getColumnName(), aDC.getDataType());
            aTable.getColumns().add((DataColumn)bDC);
        }
        ArrayList<PointShape> vectors = new ArrayList<PointShape>();
        newPoints.clear();
        int s = 0;
        while (true) {
            block15: {
                PointShape aPS;
                block14: {
                    if (s >= aLayer.getShapeNum()) {
                        aLayer.setShapes(new ArrayList(vectors));
                        aLayer.setExtent(GeometryUtil.getPointsExtent(newPoints));
                        aLayer.getAttributeTable().setTable(aTable);
                        return aLayer;
                    }
                    aPS = (PointShape)aLayer.getShapes().get(s);
                    if (fromProj.getProjectionName() != ProjectionNames.LongLat) break block14;
                    switch (toProj.getProjectionName()) {
                        case Lambert_Conformal_Conic: 
                        case North_Polar_Stereographic_Azimuthal: {
                            if (!(aPS.getPoint().X < -89.0)) break;
                            break block15;
                        }
                        case South_Polar_Stereographic_Azimuthal: {
                            if (aPS.getPoint().Y > 89.0) break block15;
                        }
                    }
                }
                double[] fromP = new double[]{aPS.getPoint().X, aPS.getPoint().Y};
                double[][] points = new double[][]{(double[])fromP.clone()};
                try {
                    Reproject.reprojectPoints((double[][])points, (ProjectionInfo)toProj, (ProjectionInfo)fromProj, (int)0, (int)points.length);
                    double[] toP = points[0];
                    switch (aLayer.getLayerDrawType()) {
                        case VECTOR: {
                            ((WindArrow)aPS).angle = ProjectionUtil.projectAngle((double)((WindArrow)aPS).angle, (double[])toP, (double[])fromP, (ProjectionInfo)fromProj, (ProjectionInfo)toProj);
                            break;
                        }
                        case BARB: {
                            ((WindBarb)aPS).angle = ProjectionUtil.projectAngle((double)((WindBarb)aPS).angle, (double[])toP, (double[])fromP, (ProjectionInfo)fromProj, (ProjectionInfo)toProj);
                            break;
                        }
                        case STATION_MODEL: {
                            ((StationModelShape)aPS).windBarb.angle = ProjectionUtil.projectAngle((double)((StationModelShape)aPS).windBarb.angle, (double[])toP, (double[])fromP, (ProjectionInfo)fromProj, (ProjectionInfo)toProj);
                            break;
                        }
                    }
                    newPoints.add(aPS.getPoint());
                    vectors.add(aPS);
                    DataRow aDR = (DataRow)oLayer.getAttributeTable().getTable().getRows().get(s);
                    aTable.getRows().add((Object)aDR);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++s;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void projectWindLayer(VectorLayer oLayer, ProjectionInfo toProj, boolean IfReprojectAngle) {
        ProjectionInfo fromProj = oLayer.getProjInfo();
        if (fromProj.toProj4String().equals(toProj.toProj4String())) {
            if (oLayer.isProjected()) {
                oLayer.getOriginData();
            }
            return;
        }
        if (oLayer.isProjected()) {
            oLayer.getOriginData();
        } else {
            oLayer.updateOriginData();
        }
        double refLon = toProj.getRefCutLon();
        if (oLayer.getExtent().maxX > 180.0 && oLayer.getExtent().minX > refLon) {
            refLon += 360.0;
        }
        ArrayList<PointD> newPoints = new ArrayList<PointD>();
        DataTable aTable = new DataTable();
        for (DataColumn aDC : oLayer.getAttributeTable().getTable().getColumns()) {
            Field bDC = new Field(aDC.getColumnName(), aDC.getDataType());
            aTable.getColumns().add((DataColumn)bDC);
        }
        ArrayList<PointShape> shapes = new ArrayList<PointShape>();
        newPoints.clear();
        block12: for (int s = 0; s < oLayer.getShapeNum(); ++s) {
            PointShape aPS = (PointShape)oLayer.getShapes().get(s);
            if (fromProj.getProjectionName() == ProjectionNames.LongLat) {
                switch (toProj.getProjectionName()) {
                    case Lambert_Conformal_Conic: 
                    case North_Polar_Stereographic_Azimuthal: {
                        if (!(aPS.getPoint().Y < -89.0)) break;
                        continue block12;
                    }
                    case South_Polar_Stereographic_Azimuthal: {
                        if (aPS.getPoint().Y > 89.0) continue block12;
                    }
                }
            }
            double[] fromP = new double[]{aPS.getPoint().X, aPS.getPoint().Y};
            double[][] points = new double[][]{(double[])fromP.clone()};
            try {
                Reproject.reprojectPoints((double[][])points, (ProjectionInfo)fromProj, (ProjectionInfo)toProj, (int)0, (int)points.length);
                double[] toP = points[0];
                PointD aPoint = new PointD();
                aPoint.X = (float)toP[0];
                aPoint.Y = (float)toP[1];
                aPS.setPoint(aPoint);
                if (IfReprojectAngle) {
                    switch (oLayer.getLayerDrawType()) {
                        case VECTOR: {
                            ((WindArrow)aPS).angle = ProjectionUtil.projectAngle((double)((WindArrow)aPS).angle, (double[])fromP, (double[])toP, (ProjectionInfo)fromProj, (ProjectionInfo)toProj);
                            break;
                        }
                        case BARB: {
                            ((WindBarb)aPS).angle = ProjectionUtil.projectAngle((double)((WindBarb)aPS).angle, (double[])fromP, (double[])toP, (ProjectionInfo)fromProj, (ProjectionInfo)toProj);
                            break;
                        }
                        case STATION_MODEL: {
                            ((StationModelShape)aPS).windBarb.angle = ProjectionUtil.projectAngle((double)((StationModelShape)aPS).windBarb.angle, (double[])fromP, (double[])toP, (ProjectionInfo)fromProj, (ProjectionInfo)toProj);
                            break;
                        }
                    }
                }
                newPoints.add(aPoint);
                shapes.add(aPS);
                DataRow aDR = (DataRow)oLayer.getAttributeTable().getTable().getRows().get(s);
                aTable.getRows().add((Object)aDR);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        oLayer.setShapes(new ArrayList(shapes));
        oLayer.setExtent(GeometryUtil.getPointsExtent(newPoints));
        oLayer.getAttributeTable().setTable(aTable);
        if (oLayer.getLabelPoints().size() > 0) {
            oLayer.setLabelPoints(ProjectionUtil.projectGraphic(oLayer.getLabelPoints(), (ProjectionInfo)fromProj, (ProjectionInfo)toProj));
        }
    }
}

