/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.info;

import java.util.ArrayList;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.meteoinfo.common.Direction;
import org.meteoinfo.common.GridLabel;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.XAlign;
import org.meteoinfo.common.YAlign;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.ProjectionUtil;

public class Aitoff
extends ProjectionInfo {
    public Aitoff(CoordinateReferenceSystem crs) {
        super(crs);
    }

    @Override
    public ProjectionNames getProjectionName() {
        return ProjectionNames.Aitoff;
    }

    @Override
    public void updateBoundary() {
        double lat;
        double epsilon = 1.0E-10;
        double cenLon = this.getCenterLon();
        double minLon = cenLon - 180.0 + epsilon;
        double maxLon = cenLon + 180.0 - epsilon;
        double minLat = -90.0;
        double maxLat = 90.0;
        ArrayList<PointD> points = new ArrayList<PointD>();
        double lon = minLon;
        lon = maxLon;
        for (lat = minLat; lat < maxLat; lat += 1.0) {
            points.add(new PointD(lon, lat));
        }
        lon = minLon;
        for (lat = maxLat; lat > minLat; lat -= 1.0) {
            points.add(new PointD(lon, lat));
        }
        lat = minLat;
        points.add(new PointD(lon, lat));
        PolygonShape ps = new PolygonShape();
        ps.setPoints(points);
        this.boundary = ProjectionUtil.projectPolygonShape(ps, KnownCoordinateSystems.geographic.world.WGS1984, this);
    }

    @Override
    public Object[] checkGridLabel(GridLabel gl, float shift) {
        float angle = gl.getAngle();
        double v = gl.getValue();
        float xShift = 0.0f;
        float yShift = 0.0f;
        XAlign xAlign = XAlign.CENTER;
        YAlign yAlign = YAlign.CENTER;
        if (v == 0.0) {
            if (angle == 90.0f) {
                xShift = shift;
                xAlign = XAlign.LEFT;
            } else if (angle == 270.0f) {
                xShift = -shift;
                xAlign = XAlign.RIGHT;
            } else if (angle < 90.0f) {
                xShift = shift;
                xAlign = XAlign.LEFT;
                yAlign = YAlign.BOTTOM;
            } else if (angle > 90.0f && angle <= 180.0f) {
                xShift = shift;
                xAlign = XAlign.LEFT;
                yAlign = YAlign.TOP;
            } else if (angle > 180.0f && angle < 270.0f) {
                xShift = -shift;
                xAlign = XAlign.RIGHT;
                yAlign = YAlign.TOP;
            } else if (angle > 270.0f && angle <= 360.0f) {
                xShift = -shift;
                xAlign = XAlign.RIGHT;
                yAlign = YAlign.BOTTOM;
            }
        } else if (v > 0.0) {
            if (gl.getLabDirection() == Direction.East) {
                xShift = shift;
                xAlign = XAlign.LEFT;
                yAlign = YAlign.BOTTOM;
            } else {
                xShift = -shift;
                xAlign = XAlign.RIGHT;
                yAlign = YAlign.BOTTOM;
            }
        } else if (gl.getLabDirection() == Direction.East) {
            xShift = shift;
            xAlign = XAlign.LEFT;
            yAlign = YAlign.TOP;
        } else {
            xShift = -shift;
            xAlign = XAlign.RIGHT;
            yAlign = YAlign.TOP;
        }
        return new Object[]{Float.valueOf(xShift), Float.valueOf(yShift), xAlign, yAlign};
    }
}

