/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.dataframe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.meteoinfo.dataframe.DataFrame;
import org.meteoinfo.dataframe.DateTimeIndex;
import org.meteoinfo.dataframe.GroupBy;
import org.meteoinfo.dataframe.impl.Aggregation;
import org.meteoinfo.dataframe.impl.Function;
import org.meteoinfo.dataframe.impl.Grouping;
import org.meteoinfo.dataframe.impl.SparseBitSet;
import org.meteoinfo.ndarray.InvalidRangeException;

public class DataFrameGroupBy
extends GroupBy
implements Iterable<Map.Entry<Object, DataFrame>> {
    private final DataFrame dataFrame;
    private Map<Object, DataFrame> dfGroups = null;

    public DataFrameGroupBy(Grouping groups, DataFrame dataFrame) {
        this.groups = groups;
        this.dataFrame = dataFrame;
    }

    public int groupNumber() {
        return this.groups.keys().size();
    }

    public DataFrame getGroup(Object key) throws InvalidRangeException {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        SparseBitSet _rows = this.groups.getGroup(key);
        int r = _rows.nextSetBit(0);
        while (r >= 0) {
            rows.add(r);
            r = _rows.nextSetBit(r + 1);
        }
        return (DataFrame)this.dataFrame.select(rows);
    }

    public <V> DataFrame apply(Function<?, ?> function) {
        DataFrame df = this.groups.apply(this.dataFrame, function);
        if (this.dataFrame.getIndex() instanceof DateTimeIndex) {
            ((DateTimeIndex)df.getIndex()).setPeriod(((DateTimeIndex)this.dataFrame.getIndex()).getResamplePeriod());
        }
        return df;
    }

    @Override
    public DataFrame count() {
        DataFrame r = this.apply(new Aggregation.Count());
        return r;
    }

    @Override
    public DataFrame sum() {
        DataFrame r = this.apply(new Aggregation.Sum());
        return r;
    }

    @Override
    public DataFrame mean() {
        DataFrame r = this.apply(new Aggregation.Mean());
        return r;
    }

    @Override
    public DataFrame min() {
        DataFrame r = this.apply(new Aggregation.Min());
        return r;
    }

    @Override
    public DataFrame max() {
        DataFrame r = this.apply(new Aggregation.Max());
        return r;
    }

    @Override
    public DataFrame median() {
        DataFrame r = this.apply(new Aggregation.Median());
        return r;
    }

    @Override
    public DataFrame stdDev() {
        DataFrame r = this.apply(new Aggregation.StdDev());
        return r;
    }

    @Override
    public DataFrame percentile(double quantile) {
        DataFrame r = this.apply(new Aggregation.Percentile(quantile * 100.0));
        return r;
    }

    @Override
    public Iterator<Map.Entry<Object, DataFrame>> iterator() {
        if (this.dfGroups == null) {
            this.dfGroups = new LinkedHashMap<Object, DataFrame>();
            for (Map.Entry<Object, SparseBitSet> v : this.groups) {
                try {
                    this.dfGroups.put(v.getKey(), this.getGroup(v.getKey()));
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.dfGroups.entrySet().iterator();
    }
}

