/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.dataframe.impl;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.meteoinfo.dataframe.DataFrame;
import org.meteoinfo.dataframe.Series;
import org.meteoinfo.dataframe.impl.Function;

public class Views {

    public static class FillNaFunction<V>
    implements Function<V, V> {
        private final V fill;

        public FillNaFunction(V fill) {
            this.fill = fill;
        }

        @Override
        public V apply(V value) {
            return value == null ? this.fill : value;
        }
    }

    public static class FlatView<V>
    extends AbstractList<V> {
        private final DataFrame df;

        public FlatView(DataFrame df) {
            this.df = df;
        }

        @Override
        public V get(int index) {
            return (V)this.df.getValue(index % this.df.length(), index / this.df.length());
        }

        @Override
        public int size() {
            return this.df.size() * this.df.length();
        }
    }

    public static class TransformedSeriesView<V, U>
    extends AbstractList<U> {
        protected final DataFrame df;
        protected final int index;
        protected final boolean transpose;
        protected final Function<V, U> transform;

        public TransformedSeriesView(DataFrame df, Function<V, U> transform, int index, boolean transpose) {
            this.df = df;
            this.transform = transform;
            this.index = index;
            this.transpose = transpose;
        }

        @Override
        public U get(int index) {
            Object value = this.transpose ? this.df.getValue(index, this.index) : this.df.getValue(this.index, index);
            return this.transform.apply(value);
        }

        @Override
        public int size() {
            return this.transpose ? this.df.length() : this.df.size();
        }
    }

    public static class TransformedView<V, U>
    extends AbstractList<List<U>> {
        protected final DataFrame df;
        protected final Function<V, U> transform;
        protected final boolean transpose;

        public TransformedView(DataFrame df, Function<V, U> transform, boolean transpose) {
            this.df = df;
            this.transform = transform;
            this.transpose = transpose;
        }

        @Override
        public List<U> get(int index) {
            return new TransformedSeriesView<V, U>(this.df, this.transform, index, !this.transpose);
        }

        @Override
        public int size() {
            return this.transpose ? this.df.length() : this.df.size();
        }
    }

    public static class DataFrameMapView<V>
    extends AbstractMap<Object, V> {
        private final DataFrame df;
        private final int index;
        private final boolean transpose;

        public DataFrameMapView(DataFrame df, int index, boolean transpose) {
            this.df = df;
            this.index = index;
            this.transpose = transpose;
        }

        @Override
        public Set<Map.Entry<Object, V>> entrySet() {
            return new AbstractSet<Map.Entry<Object, V>>(){

                @Override
                public Iterator<Map.Entry<Object, V>> iterator() {
                    List<String> names = transpose ? df.getIndex().getValues() : new ArrayList<String>(df.getColumns().getNames());
                    final Iterator<String> it = names.iterator();
                    return new Iterator<Map.Entry<Object, V>>(){
                        int value = 0;

                        @Override
                        public boolean hasNext() {
                            return it.hasNext();
                        }

                        @Override
                        public Map.Entry<Object, V> next() {
                            final Object key = it.next();
                            final int value = this.value++;
                            return new Map.Entry<Object, V>(){

                                @Override
                                public Object getKey() {
                                    return key;
                                }

                                @Override
                                public V getValue() {
                                    return transpose ? df.getValue(value, index) : df.getValue(index, value);
                                }

                                @Override
                                public V setValue(V value2) {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return transpose ? df.length() : df.size();
                }
            };
        }
    }

    public static class MapView<V>
    extends AbstractList<Map<Object, V>> {
        private final DataFrame df;
        private final boolean transpose;

        public MapView(DataFrame df, boolean transpose) {
            this.df = df;
            this.transpose = transpose;
        }

        @Override
        public Map<Object, V> get(int index) {
            return new DataFrameMapView(this.df, index, !this.transpose);
        }

        @Override
        public int size() {
            return this.transpose ? this.df.length() : this.df.size();
        }
    }

    public static class SeriesListView<V>
    extends AbstractList<V> {
        private final DataFrame df;
        private final int index;
        private final boolean transpose;

        public SeriesListView(DataFrame df, int index, boolean transpose) {
            this.df = df;
            this.index = index;
            this.transpose = transpose;
        }

        @Override
        public V get(int index) {
            return (V)(this.transpose ? this.df.getValue(index, this.index) : this.df.getValue(this.index, index));
        }

        @Override
        public int size() {
            return this.transpose ? this.df.length() : this.df.size();
        }
    }

    public static class DataFrameListView<V>
    extends AbstractList<V> {
        private final DataFrame df;
        private final int index;
        private final boolean transpose;

        public DataFrameListView(DataFrame df, int index, boolean transpose) {
            this.df = df;
            this.index = index;
            this.transpose = transpose;
        }

        @Override
        public V get(int index) {
            return (V)(this.transpose ? this.df.getValue(index, this.index) : this.df.getValue(this.index, index));
        }

        @Override
        public int size() {
            return this.transpose ? this.df.length() : this.df.size();
        }
    }

    public static class ListView<V>
    extends AbstractList<List<V>> {
        private final Object df;
        private final boolean transpose;

        public ListView(DataFrame df, boolean transpose) {
            this.df = df;
            this.transpose = transpose;
        }

        public ListView(Series df) {
            this.df = df;
            this.transpose = false;
        }

        @Override
        public List<V> get(int index) {
            return new DataFrameListView((DataFrame)this.df, index, !this.transpose);
        }

        @Override
        public int size() {
            return this.transpose ? ((DataFrame)this.df).length() : ((DataFrame)this.df).size();
        }
    }
}

