/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.lab;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Options {
    private String _fileName;
    private Font _textFont = new Font("Simsun", 0, 15);
    private Point mainFormLocation = new Point(0, 0);
    private Dimension mainFormSize = new Dimension(1000, 650);
    private String currentFolder;
    private List<String> recentFolders = new ArrayList<String>();
    private List<String> openedFiles = new ArrayList<String>();
    private List<String> recentFiels = new ArrayList<String>();
    private String lookFeel = "Nimbus";
    private boolean doubleBuffer = true;
    private boolean lafDecorated = false;
    private boolean dockWindowDocorated = true;

    public Font getTextFont() {
        return this._textFont;
    }

    public void setTextFont(Font font) {
        this._textFont = font;
    }

    public String getFileName() {
        return this._fileName;
    }

    public Point getMainFormLocation() {
        return this.mainFormLocation;
    }

    public void setMainFormLocation(Point value) {
        this.mainFormLocation = value;
    }

    public Dimension getMainFormSize() {
        return this.mainFormSize;
    }

    public void setMainFormSize(Dimension value) {
        this.mainFormSize = value;
    }

    public String getCurrentFolder() {
        return this.currentFolder;
    }

    public void setCurrentFolder(String value) {
        this.currentFolder = value;
        System.setProperty("user.dir", value);
    }

    public List<String> getRecentFolders() {
        return this.recentFolders;
    }

    public void setRecentFolders(List<String> value) {
        this.recentFolders = value;
    }

    public List<String> getOpenedFiles() {
        return this.openedFiles;
    }

    public void setOpenedFiles(List<String> value) {
        this.openedFiles = value;
    }

    public List<String> getRecentFiles() {
        return this.recentFiels;
    }

    public void setRecentFiles(List<String> value) {
        this.recentFiels = value;
    }

    public String getLookFeel() {
        return this.lookFeel;
    }

    public void setLookFeel(String value) {
        this.lookFeel = value;
    }

    public boolean isDoubleBuffer() {
        return this.doubleBuffer;
    }

    public void setDoubleBuffer(boolean value) {
        this.doubleBuffer = value;
    }

    public boolean isLafDecorated() {
        return this.lafDecorated;
    }

    public void setLafDecorated(boolean value) {
        this.lafDecorated = value;
    }

    public boolean isDockWindowDecorated() {
        return this.dockWindowDocorated;
    }

    public void setDowckWindowDecorated(boolean value) {
        this.dockWindowDocorated = value;
    }

    public void addRecentFile(String fileName) {
        this.recentFiels.add(fileName);
        while (this.recentFiels.size() > 15) {
            this.recentFiels.remove(0);
        }
    }

    public void saveConfigFile(String fileName) throws ParserConfigurationException {
        if (fileName == null) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElement("MeteoInfo");
        File af = new File(fileName);
        Attr fn = doc.createAttribute("File");
        Attr type = doc.createAttribute("Type");
        fn.setValue(af.getName());
        type.setValue("configurefile");
        root.setAttributeNode(fn);
        root.setAttributeNode(type);
        doc.appendChild(root);
        Element path = doc.createElement("Path");
        Attr pAttr = doc.createAttribute("OpenPath");
        pAttr.setValue(this.currentFolder);
        path.setAttributeNode(pAttr);
        root.appendChild(path);
        for (String folder : this.recentFolders) {
            Element folderElem = doc.createElement("RecentFolder");
            Attr attr = doc.createAttribute("Folder");
            attr.setValue(folder);
            folderElem.setAttributeNode(attr);
            path.appendChild(folderElem);
        }
        Element file = doc.createElement("File");
        Element ofiles = doc.createElement("OpenedFiles");
        for (String string : this.openedFiles) {
            Element ofileElem = doc.createElement("OpenedFile");
            Attr fAttr = doc.createAttribute("File");
            fAttr.setValue(string);
            ofileElem.setAttributeNode(fAttr);
            ofiles.appendChild(ofileElem);
        }
        file.appendChild(ofiles);
        Element rfiles = doc.createElement("RecentFiles");
        for (String rfile : this.openedFiles) {
            Element rfileElem = doc.createElement("RecentFile");
            Attr fAttr = doc.createAttribute("File");
            fAttr.setValue(rfile);
            rfileElem.setAttributeNode(fAttr);
            rfiles.appendChild(rfileElem);
        }
        file.appendChild(rfiles);
        root.appendChild(file);
        Element element = doc.createElement("Font");
        Element textFont = doc.createElement("TextFont");
        Attr nameAttr = doc.createAttribute("FontName");
        Attr sizeAttr = doc.createAttribute("FontSize");
        nameAttr.setValue(this._textFont.getFontName());
        sizeAttr.setValue(String.valueOf(this._textFont.getSize()));
        textFont.setAttributeNode(nameAttr);
        textFont.setAttributeNode(sizeAttr);
        element.appendChild(textFont);
        root.appendChild(element);
        Element lf = doc.createElement("LookFeel");
        Attr lfAttr = doc.createAttribute("Name");
        Attr lafDecoratedAttr = doc.createAttribute("LafDecorated");
        Attr dockWinDecoratedAttr = doc.createAttribute("DockWindowDecorated");
        lfAttr.setValue(this.lookFeel);
        lafDecoratedAttr.setValue(String.valueOf(this.lafDecorated));
        dockWinDecoratedAttr.setValue(String.valueOf(this.dockWindowDocorated));
        lf.setAttributeNode(lfAttr);
        lf.setAttributeNode(lafDecoratedAttr);
        lf.setAttributeNode(dockWinDecoratedAttr);
        root.appendChild(lf);
        Element eFigure = doc.createElement("Figure");
        Attr dbAttr = doc.createAttribute("DoubleBuffering");
        dbAttr.setValue(String.valueOf(this.doubleBuffer));
        eFigure.setAttributeNode(dbAttr);
        root.appendChild(eFigure);
        Element startForm = doc.createElement("Startup");
        Attr mfLocationAttr = doc.createAttribute("MainFormLocation");
        Attr mfSizeAttr = doc.createAttribute("MainFormSize");
        mfLocationAttr.setValue(String.valueOf(this.mainFormLocation.x) + "," + String.valueOf(this.mainFormLocation.y));
        mfSizeAttr.setValue(String.valueOf(this.mainFormSize.width) + "," + String.valueOf(this.mainFormSize.height));
        startForm.setAttributeNode(mfLocationAttr);
        startForm.setAttributeNode(mfSizeAttr);
        root.appendChild(startForm);
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            DOMSource source = new DOMSource(doc);
            Properties properties = transformer.getOutputProperties();
            properties.setProperty("encoding", "UTF-8");
            properties.setProperty("indent", "yes");
            properties.setProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperties(properties);
            FileOutputStream out = new FileOutputStream(fileName);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (IOException | TransformerException exception) {
            // empty catch block
        }
    }

    public void loadConfigFile(String fileName) throws ParserConfigurationException, SAXException, IOException {
        this._fileName = fileName;
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
        InputSource is = new InputSource(br);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(is);
        Element root = doc.getDocumentElement();
        try {
            Element path = (Element)root.getElementsByTagName("Path").item(0);
            String currentPath = path.getAttributes().getNamedItem("OpenPath").getNodeValue();
            if (new File(currentPath).isDirectory()) {
                this.currentFolder = currentPath;
                System.setProperty("user.dir", currentPath);
            } else {
                this.currentFolder = System.getProperty("user.dir");
            }
            this.recentFolders = new ArrayList<String>();
            NodeList rfolders = path.getElementsByTagName("RecentFolder");
            if (rfolders != null) {
                for (int i = 0; i < rfolders.getLength(); ++i) {
                    Node rfolder = rfolders.item(i);
                    String folder = rfolder.getAttributes().getNamedItem("Folder").getNodeValue();
                    if (this.recentFolders.contains(folder)) continue;
                    this.recentFolders.add(folder);
                }
            }
            Element ofiles = (Element)root.getElementsByTagName("OpenedFiles").item(0);
            this.openedFiles = new ArrayList<String>();
            NodeList ofs = ofiles.getElementsByTagName("OpenedFile");
            if (ofs != null) {
                for (int i = 0; i < ofs.getLength(); ++i) {
                    Node ofile = ofs.item(i);
                    String file = ofile.getAttributes().getNamedItem("File").getNodeValue();
                    this.openedFiles.add(file);
                }
            }
            Element rfiles = (Element)root.getElementsByTagName("RecentFiles").item(0);
            this.recentFiels = new ArrayList<String>();
            NodeList rfs = rfiles.getElementsByTagName("RecentFile");
            if (rfs != null) {
                for (int i = 0; i < rfs.getLength(); ++i) {
                    Node rfile = rfs.item(i);
                    String file = rfile.getAttributes().getNamedItem("File").getNodeValue();
                    this.openedFiles.add(file);
                }
            }
            Element font = (Element)root.getElementsByTagName("Font").item(0);
            Node textFont = font.getElementsByTagName("TextFont").item(0);
            String fontName = textFont.getAttributes().getNamedItem("FontName").getNodeValue();
            float fontSize = Float.parseFloat(textFont.getAttributes().getNamedItem("FontSize").getNodeValue());
            this._textFont = new Font(fontName, 0, (int)fontSize);
            if (root.getElementsByTagName("LookFeel") != null) {
                Element lf = (Element)root.getElementsByTagName("LookFeel").item(0);
                this.lookFeel = lf.getAttributes().getNamedItem("Name").getNodeValue();
                this.lafDecorated = Boolean.valueOf(lf.getAttributes().getNamedItem("LafDecorated").getNodeValue());
                this.dockWindowDocorated = Boolean.valueOf(lf.getAttributes().getNamedItem("DockWindowDecorated").getNodeValue());
            }
            if (root.getElementsByTagName("Figure").item(0) != null) {
                Element eFigure = (Element)root.getElementsByTagName("Figure").item(0);
                this.doubleBuffer = Boolean.valueOf(eFigure.getAttributes().getNamedItem("DoubleBuffering").getNodeValue());
            }
            Node startForm = root.getElementsByTagName("Startup").item(0);
            String loc = startForm.getAttributes().getNamedItem("MainFormLocation").getNodeValue();
            this.mainFormLocation.x = Integer.parseInt(loc.split(",")[0]);
            this.mainFormLocation.y = Integer.parseInt(loc.split(",")[1]);
            String size = startForm.getAttributes().getNamedItem("MainFormSize").getNodeValue();
            this.mainFormSize.width = Integer.parseInt(size.split(",")[0]);
            this.mainFormSize.height = Integer.parseInt(size.split(",")[1]);
        }
        catch (NumberFormatException | DOMException runtimeException) {
            // empty catch block
        }
    }
}

