print 'Open data files...'
f_uwnd = addfile('D:/Temp/nc/uwnd.2011.nc')
f_vwnd = addfile('D:/Temp/nc/vwnd.2011.nc')
f_omega = addfile('D:/Temp/nc/omega.2011.nc')

print 'Calculate vertical helicity...'
tidx = 173    # Jun 23, 2011
t = f_uwnd.gettime(tidx)
level = '700'
lat = '15:55'
lon = '70:135'
uwnd = f_uwnd['uwnd'][tidx,level,lat,lon]
vwnd = f_vwnd['vwnd'][tidx,level,lat,lon]
omega = f_omega['omega'][tidx,level,lat,lon]
wd = meteolib.vorticity(uwnd, vwnd)
lx = -(wd*omega*10.)/12.64*1e6

print 'Plot...'
axesm()
geoshow('country', edgecolor='black')
layer = contourf(lx, 20)
title('Vertical helicity (' + t.strftime('%Y-%m-%d') + ')')
colorbar(layer)