#Read data
fn = os.path.join(migl.get_sample_folder(), 'GrADS', 'model.ctl')
f = addfile(fn)
lev1 = f['U'][0,:,0,0].dimvalue(0)
lev2 = meteolib.pressure_to_height_std(lev1)
levels = []
for i in range(0, len(lev1)):
    levels.append('%i' % lev1[i])

f1 = addfile('D:/Temp/nc/elev.0.25-deg.nc')

lon1 = 10
lon2 = 170
lat1 = -30
lat2 = 60
lon = lon1
x = []
tdata = []
terrain = []
while lon <= lon2:
    lat = lat1 + (lat2 - lat1) * (lon - lon1) / (lon2 - lon1)
    print lon
    tdata.append(f['U'][0,:,'%f'%lat,'%f'%lon])
    terrain.append(f1['data'][0,'%f'%lat,'%f'%lon])
    x.append(lon)
    lon = lon + 2.5
    
terrain = array(terrain)
terrain[terrain<0] = 0
alldata = concatenate(tdata, axis=0)
alldata = reshape(alldata, (len(tdata), len(lev1)))    
alldata = alldata.T
x = array(x)

#Plot
subplot(2,1,1)
yaxis(tickin=False)
xaxis(tickin=False)
yaxis(location='right', tickvisible=False)
xaxis(location='top', tickvisible=False)
layer = contourf(x, lev2, alldata, 10)
fill_between(x, terrain, color='gray')
plot(x, terrain, color='k')
yticks(lev2, levels)
ylabel('Pressure (hPa)')
xlabel('Longitude')
xlim(10, 170)
ylim(0, lev2.max())
colorbar(layer, aspect=25)

subplot(2,1,2,axestype='map')
lat = [lat1, lat2]
lon = [lon1, lon2]
geoshow(lat, lon, size=2, color='b')
geoshow('coastline', color='k')
xlim(0, 180)
ylim(-55, 70)

#savefig('D:/Temp/figure/vertical_slash.png', 550, 500, dpi=300)