fn = os.path.join(migl.get_sample_folder(), 'ASCII', 'pm_vis_rh.txt')
df = DataFrame.read_table(fn, format='%3f')
pm = df['PM2.5'].values
vis = df['VIS'].values
rh = df['RH'].values

#Plot data scatter points
ls = scatter(pm, vis, s=8, c=rh, cmap='NCV_jet', edgecolor=None, cnum=20)
xlim(0, 450)
ylim(0, 30)
xlabel(r'$\rm{PM_{2.5}} \ (\mu g \ m^{-3})$')
ylabel('Visibility (km)') 
colorbar(ls, label='RH(%)')

#Pow law fitting
a, b, r, f = fitting.powerfit(pm, vis, func=True)

#Plot fitting line
xx = linspace(pm.min(), pm.max(), 100)
yy = fitting.predict(f, xx)
plot(xx, yy, '-b', linewidth=2)
text(250, 20, r'$y = ' + '%.4f' % a + 'x^{%.4f' % b + '}$', fontsize=16)
text(250, 18, r'$r^2=%.4f' % r + '$', fontsize=16)