x = arange(-5.01, 5.25, 0.25)
y = arange(-5.01, 5.25, 0.25)
xx, yy = meshgrid(x, y)
z = sin(xx**2+yy**2)
f = interpolate.interp2d(x, y, z, kind='spline')

xnew = arange(-5.01, 5.01, 1e-2)
ynew = arange(-5.01, 5.01, 1e-2)
znew = f(xnew, ynew)

ax = axes3d()
ax.set_rotation(320)
scatter3(xnew, ynew, znew, 4, c='b')
surf(xx, yy, z, edgecolor=None, cmap='MPL_PiYG', alpha=0.6)