fn = os.path.join(migl.get_sample_folder(), 'MICAPS', '10101414.000')
f = addfile_micaps(fn)
vname = 'Precipitation6h'
pr = f[vname][:]
lon = f['Longitude'][:]
lat = f['Latitude'][:]
layer = shaperead('china')
pr, lon, lat = rmaskout(pr, lon, lat, layer.shapes)
axesm()
geoshow('coastline', color='b')
levs = [0.1, 1, 2, 5, 10, 20, 25, 50, 100]
cols = [(255,255,255),(170,240,255),(120,230,240),(200,220,50),(240,220,20),(255,120,10),(255,90,10), \
    (240,40,0),(180,10,0),(120,10,0)]
ss = linspace(2, 12, len(cols))
layer = scatter(lon, lat, pr, levs, colors=cols, size=ss, edgecolor='gray')
title(vname)
yticks(arange(20, 51, 10))
xlim(70, 150)
ylim(15, 55)
legend(layer, loc='lower right', background='w')