fn = os.path.join(migl.get_sample_folder(), 'GrADS', 'model.ctl')
f = addfile(fn)
u = f['U'][0,'500','10:60','60:140']
v = f['V'][0,'500','10:60','60:140']
speed = sqrt(u*u+v*v)

#Plot
axesm()
geoshow('country', edgecolor='k')
levs = arange(4, 40, 4)
layer = quiver(u, v, speed, levs=levs, size=8, width=1, \
    headwidth=5, overhang=0)
quiverkey(layer, 0.74, 0.18, 15, '15 m/s', overhang=0, bbox={'edge':True, 'fill':True})
colorbar(layer)
title('Wind field')
yticks([20,40,60])
xaxis(linewidth=2)
yaxis(linewidth=2)