import struct

fn = 'D:/Temp/binary/HIMA_2017_09_26_17_30_L_PJ1.GPF'

#Read data header parameters
f = open(fn, 'rb')
fileid, = struct.unpack('2s', f.read(2))
version, = struct.unpack('<h', f.read(2))
satid, = struct.unpack('<h', f.read(2))
year, = struct.unpack('<h', f.read(2))
month, = struct.unpack('<h', f.read(2))
day, = struct.unpack('<h', f.read(2))
hour, = struct.unpack('<h', f.read(2))
minute, = struct.unpack('<h', f.read(2))
chnums, = struct.unpack('<h', f.read(2))
pjtype, = struct.unpack('<h', f.read(2))
width, = struct.unpack('<h', f.read(2))
height, = struct.unpack('<h', f.read(2))
clonres, = struct.unpack('<f', f.read(4))
clatres, = struct.unpack('<f', f.read(4))
stdlat1, = struct.unpack('<f', f.read(4))
stdlat2, = struct.unpack('<f', f.read(4))
earthr, = struct.unpack('<f', f.read(4))
minlat, = struct.unpack('<f', f.read(4))
maxlat, = struct.unpack('<f', f.read(4))
minlon, = struct.unpack('<f', f.read(4))
maxlon, = struct.unpack('<f', f.read(4))
ltlat, = struct.unpack('<f', f.read(4))
ltlon, = struct.unpack('<f', f.read(4))
rtlat, = struct.unpack('<f', f.read(4))
rtlon, = struct.unpack('<f', f.read(4))
lblat, = struct.unpack('<f', f.read(4))
lblon, = struct.unpack('<f', f.read(4))
rblat, = struct.unpack('<f', f.read(4))
rblon, = struct.unpack('<f', f.read(4))
stdlon, = struct.unpack('<f', f.read(4))
centerlon, = struct.unpack('<f', f.read(4))
centerlat, = struct.unpack('<f', f.read(4))
chindex = []
for i in range(chnums):
    chindex.append(struct.unpack('b', f.read(1))[0])
f.read(128 - chnums)
plonres, = struct.unpack('<f', f.read(4))
platres, = struct.unpack('<f', f.read(4))
f.read(1808)

#Read calibration table
f.read(32768)

f.close()

#Read one channel data
cn = 1    #Infrared channel 1
skipn = 2048 + 32768
for i in range(1, cn):
    if chindex[i-1] < 5:    #Infrared channel
        byten = 2
    else:
        byten = 1    #Visible light channel
    skipn += width * height * byten
if cn < 5:
    data = binread(fn, [height, width], 'short', skip=skipn)
else:
    data = binread(fn, [height, width], 'byte', skip=skipn)
data = data[::-1,:]

#Get x/y coordinate
if pjtype == 1:    #Lon/lat projection
    proj = projinfo()
    x = linspace(ltlon, rtlon, width)
    y = linspace(lblat, ltlat, height)
elif pjtype == 3:    #Lambert projection
    proj = projinfo(proj='lcc', lat_0=centerlat, lon_0=centerlon, lat_1=stdlat1, \
        lat_2=stdlat2)
    sx, sy = project(lblon, lblat, toproj=proj)
    x = arange1(sx, width, plonres)
    y = arange1(sy, height, platres)

#Plot
axesm(projinfo=proj)
geoshow('coastline', color='b')
levs = arange(300, 1000, 20)
cols = makecolors(len(levs)+1, cmap='MPL_gist_gray')
cols[0] = 'w'
layer = imshow(x, y, data, levs, colors=cols, proj=proj)
colorbar(layer)
t = datetime.datetime(year, month, day, hour, minute)
title('Himawari (' + t.strftime('%Y-%m-%d') + ')')